/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.io.AbstractResourceLoader;
import vip.justlive.oxygen.core.io.PropertySource;
import vip.justlive.oxygen.core.io.SourceResource;
import vip.justlive.oxygen.core.util.ClassUtils;

public class PropertiesLoader
extends AbstractResourceLoader
implements PropertySource {
    private static final Logger log = LoggerFactory.getLogger(PropertiesLoader.class);
    private final String[] locations;
    private final Properties props = new Properties();

    public PropertiesLoader(String ... locations) {
        this(ClassUtils.getDefaultClassLoader(), locations);
    }

    public PropertiesLoader(ClassLoader loader, String ... locations) {
        this.locations = locations;
        this.loader = loader;
    }

    @Override
    public Properties props() {
        if (!this.ready) {
            this.init();
        }
        return this.props;
    }

    @Override
    public void init() {
        if (this.ready) {
            return;
        }
        this.ready = true;
        this.resources.addAll(this.parse(this.locations));
        for (SourceResource resource : this.resources) {
            try {
                Reader reader = this.getReader(resource);
                Throwable throwable = null;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("loading resource [{}]", (Object)resource.path());
                    }
                    this.props.load(reader);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug("resource [{}] read error", (Object)resource.path(), (Object)e);
                }
                if (this.ignoreNotFound) continue;
                throw Exceptions.wrap(e);
            }
        }
    }
}

