/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import vip.justlive.oxygen.core.io.SourceResource;
import vip.justlive.oxygen.core.util.MoreObjects;
import vip.justlive.oxygen.core.util.Urls;

public class FileSystemResource
implements SourceResource {
    private final File file;
    private String filePath;
    private Path path;

    public FileSystemResource(String filePath) {
        this.file = new File(MoreObjects.notNull(filePath));
        this.filePath = this.file.toPath().normalize().toString();
    }

    public FileSystemResource(File file) {
        this.file = MoreObjects.notNull(file);
    }

    public FileSystemResource(Path path) {
        this.path = MoreObjects.notNull(path);
        this.file = path.toFile();
    }

    @Override
    public String path() {
        if (this.filePath == null) {
            this.filePath = this.file.toPath().normalize().toString();
        }
        return this.filePath;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.path == null) {
            this.path = this.file.toPath();
        }
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    public Path getPath() {
        if (this.path == null) {
            this.path = this.file.toPath();
        }
        return this.path;
    }

    @Override
    public SourceResource createRelative(String path) {
        return new FileSystemResource(Urls.relativePath(this.path(), path));
    }
}

