/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.io.ClassPathResource;
import vip.justlive.oxygen.core.io.FileSystemResource;
import vip.justlive.oxygen.core.io.SourceResource;
import vip.justlive.oxygen.core.io.UrlResource;
import vip.justlive.oxygen.core.util.JarFileInfo;
import vip.justlive.oxygen.core.util.PathMatcher;
import vip.justlive.oxygen.core.util.Strings;
import vip.justlive.oxygen.core.util.Urls;

public abstract class AbstractResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(AbstractResourceLoader.class);
    protected ClassLoader loader;
    protected List<SourceResource> resources = new ArrayList<SourceResource>();
    protected boolean ignoreNotFound;
    protected String encoding;
    protected Charset charset;
    volatile boolean ready;

    public abstract void init();

    public List<SourceResource> resources() {
        return this.resources;
    }

    protected Reader getReader(SourceResource resource) throws IOException {
        if (this.charset != null) {
            return new InputStreamReader(resource.getInputStream(), this.charset);
        }
        if (this.encoding != null) {
            return new InputStreamReader(resource.getInputStream(), this.encoding);
        }
        return new InputStreamReader(resource.getInputStream());
    }

    protected List<SourceResource> parse(String ... locations) {
        LinkedList<SourceResource> list = new LinkedList<SourceResource>();
        for (String location : locations) {
            try {
                log.info("parsing resource for [{}]", (Object)location);
                if (location.startsWith("classpath*:")) {
                    list.addAll(this.resolveAllClassPathResource(location.substring("classpath*:".length())));
                    continue;
                }
                if (location.startsWith("classpath:")) {
                    list.addAll(this.resolveClassPathResource(location.substring("classpath:".length())));
                    continue;
                }
                if (location.startsWith("file:")) {
                    list.addAll(this.resolveFileSystemResource(location));
                    continue;
                }
                list.addAll(this.resolveClassPathResource(location));
            }
            catch (IOException e) {
                log.warn("location [{}] cannot find resource", (Object)location);
                if (this.ignoreNotFound) continue;
                throw Exceptions.wrap(e);
            }
        }
        return list;
    }

    private List<SourceResource> resolveAllClassPathResource(String location) throws IOException {
        LinkedList<SourceResource> list = new LinkedList<SourceResource>();
        if (Strings.isPattern(location)) {
            list.addAll(this.findMatchPath(location, true));
        } else {
            Enumeration<URL> res = this.loader.getResources(Urls.cutRootPath(location));
            if (res == null) {
                return list;
            }
            while (res.hasMoreElements()) {
                URL url = res.nextElement();
                list.add(new UrlResource(url));
            }
        }
        return list;
    }

    private List<SourceResource> resolveClassPathResource(String location) throws IOException {
        LinkedList<SourceResource> list = new LinkedList<SourceResource>();
        if (Strings.isPattern(location)) {
            list.addAll(this.findMatchPath(location, false));
        } else {
            list.add(new ClassPathResource(location, this.loader));
        }
        return list;
    }

    private List<SourceResource> resolveFileSystemResource(String location) throws IOException {
        LinkedList<SourceResource> list = new LinkedList<SourceResource>();
        if (Strings.isPattern(location)) {
            list.addAll(this.findMatchPath(location, false));
        } else {
            list.add(new FileSystemResource(location.substring("file:".length())));
        }
        return list;
    }

    private List<SourceResource> findMatchPath(String location, boolean multi) throws IOException {
        List<SourceResource> rootResources;
        LinkedList<SourceResource> all = new LinkedList<SourceResource>();
        String rootPath = PathMatcher.getRootDir(location);
        String subPattern = location.substring(rootPath.length());
        if (multi) {
            Enumeration<URL> urls = this.loader.getResources(Urls.cutRootPath(rootPath));
            rootResources = new LinkedList<SourceResource>();
            while (urls.hasMoreElements()) {
                rootResources.add(new UrlResource(urls.nextElement()));
            }
        } else {
            rootResources = this.parse(rootPath);
        }
        for (SourceResource resource : rootResources) {
            URL rootUrl = resource.getURL();
            if ("file".equals(rootUrl.getProtocol())) {
                all.addAll(this.findFileMatchPath(resource, subPattern));
                continue;
            }
            if (!Urls.isJarURL(rootUrl)) continue;
            all.addAll(this.findJarMatchPath(resource, rootUrl, subPattern));
        }
        return all;
    }

    private List<SourceResource> findJarMatchPath(SourceResource resource, URL rootUrl, String subPattern) throws IOException {
        LinkedList<SourceResource> all = new LinkedList<SourceResource>();
        try (JarFileInfo jarFileInfo = Urls.getJarFileInfo(rootUrl);){
            this.look(resource, subPattern, all, jarFileInfo.jarFile, jarFileInfo.jarFileUrl, jarFileInfo.rootEntryPath);
        }
        return all;
    }

    private void look(SourceResource resource, String subPattern, List<SourceResource> all, JarFile jarFile, String jarFileUrl, String rootEntryPath) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Looking for matching resources in jar file [{}]", (Object)jarFileUrl);
        }
        if (rootEntryPath.length() > 0 && !rootEntryPath.endsWith("/")) {
            rootEntryPath = rootEntryPath + "/";
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String relativePath;
            JarEntry entry = entries.nextElement();
            String entryPath = entry.getName();
            if (!entryPath.startsWith(rootEntryPath) || !PathMatcher.match(subPattern, relativePath = entryPath.substring(rootEntryPath.length()))) continue;
            all.add(resource.createRelative(relativePath));
        }
    }

    private List<SourceResource> findFileMatchPath(SourceResource resource, String subPattern) throws IOException {
        LinkedList<SourceResource> list = new LinkedList<SourceResource>();
        PathMatcher.findMatchedFiles(resource.getFile().getAbsoluteFile(), subPattern).forEach(file -> list.add(new FileSystemResource((File)file)));
        return list;
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

