/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.crypto;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import vip.justlive.oxygen.core.crypto.BaseEncoder;
import vip.justlive.oxygen.core.util.Hex;

public class MessageDigestEncoder
extends BaseEncoder {
    private final String algorithm;

    public MessageDigestEncoder(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    protected String doEncode(String source) {
        return Hex.encodeToString(this.create().digest(source.getBytes(StandardCharsets.UTF_8)));
    }

    private MessageDigest create() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No such hashing algorithm", e);
        }
    }
}

