/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.crypto;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import vip.justlive.oxygen.core.crypto.BaseEncoder;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.Hex;
import vip.justlive.oxygen.core.util.MoreObjects;

public class MacEncoder
extends BaseEncoder {
    private final String algorithm;
    private final byte[] secret;
    private boolean useBase64 = false;

    public MacEncoder(String algorithm, String secret) {
        this(algorithm, MoreObjects.notNull(secret).getBytes(StandardCharsets.UTF_8));
    }

    public MacEncoder(String algorithm, byte[] secret) {
        this.algorithm = MoreObjects.notNull(algorithm);
        this.secret = MoreObjects.notNull(secret);
    }

    public MacEncoder useBase64(boolean useBase64) {
        this.useBase64 = useBase64;
        return this;
    }

    @Override
    protected String doEncode(String source) {
        byte[] data = this.create().doFinal(source.getBytes(StandardCharsets.UTF_8));
        if (this.useBase64) {
            return Base64.getEncoder().encodeToString(data);
        }
        return Hex.encodeToString(data);
    }

    private Mac create() {
        try {
            Mac mac = Mac.getInstance(this.algorithm);
            mac.init(new SecretKeySpec(this.secret, this.algorithm));
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw Exceptions.wrap(e);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public boolean isUseBase64() {
        return this.useBase64;
    }
}

