/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.crypto;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import vip.justlive.oxygen.core.crypto.BaseEncoder;
import vip.justlive.oxygen.core.crypto.Encoder;
import vip.justlive.oxygen.core.crypto.Md5Encoder;
import vip.justlive.oxygen.core.crypto.MessageDigestEncoder;
import vip.justlive.oxygen.core.crypto.NoOpEncoder;
import vip.justlive.oxygen.core.exception.Exceptions;

public class DelegateEncoder
extends BaseEncoder {
    private static final String ERROR_TEMPLATE = "There is no encoder mapped for the id \"%s\"";
    private static final Map<String, Encoder> ENCODERS = new ConcurrentHashMap<String, Encoder>();
    private final String id;

    public DelegateEncoder(String id) {
        if (!ENCODERS.containsKey(id)) {
            throw new IllegalArgumentException(String.format(ERROR_TEMPLATE, id));
        }
        this.id = id;
    }

    @Override
    public String encode(String source) {
        String salt = "{".concat(this.id).concat("}");
        return salt.concat(this.doEncode(source));
    }

    @Override
    protected String doEncode(String source) {
        Encoder encoder = ENCODERS.get(this.id);
        return encoder.encode(source);
    }

    @Override
    public boolean match(String source, String raw) {
        String salt = DelegateEncoder.extractSalt(raw);
        Encoder encoder = ENCODERS.get(salt);
        if (encoder == null) {
            throw Exceptions.fail(String.format(ERROR_TEMPLATE, salt));
        }
        String value = "{".concat(salt).concat("}").concat(encoder.encode(source));
        return Objects.equals(value, raw);
    }

    @Override
    public void setUseSalt(boolean useSalt) {
        throw new UnsupportedOperationException();
    }

    static {
        ENCODERS.put("NoOp", new NoOpEncoder());
        ENCODERS.put("MD5", new Md5Encoder());
        ENCODERS.put("SHA-1", new MessageDigestEncoder("SHA-1"));
        ENCODERS.put("SHA-256", new MessageDigestEncoder("SHA-256"));
    }
}

