/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.crypto;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import vip.justlive.oxygen.core.crypto.Encoder;

public abstract class BaseEncoder
implements Encoder {
    private final SecureRandom random = new SecureRandom();
    protected int iterations = 1;
    protected boolean useSalt = false;
    protected int saltKeyLength = 8;

    static String extractSalt(String raw) {
        int start = raw.indexOf("{");
        if (start != 0) {
            return "";
        }
        int end = raw.indexOf("}", start);
        if (end < 0) {
            return "";
        }
        return raw.substring(start + 1, end);
    }

    @Override
    public String encode(String source) {
        String salt = "";
        if (this.useSalt) {
            salt = this.generateSaltKey();
        }
        return this.encode(source, salt);
    }

    protected String encode(String source, String salt) {
        String value = source.concat(salt);
        for (int i = 0; i < this.iterations; ++i) {
            value = this.doEncode(value);
        }
        if (salt.length() > 0) {
            value = this.wrapperSalt(salt).concat(value);
        }
        return value;
    }

    @Override
    public boolean match(String source, String raw) {
        String salt = BaseEncoder.extractSalt(raw);
        String value = this.encode(source, salt);
        return Objects.equals(value, raw);
    }

    protected abstract String doEncode(String var1);

    public String generateSaltKey() {
        byte[] bytes = new byte[this.saltKeyLength];
        this.random.nextBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public String wrapperSalt(String salt) {
        return "{".concat(salt).concat("}");
    }

    public SecureRandom getRandom() {
        return this.random;
    }

    public int getIterations() {
        return this.iterations;
    }

    public boolean isUseSalt() {
        return this.useSalt;
    }

    public int getSaltKeyLength() {
        return this.saltKeyLength;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public void setUseSalt(boolean useSalt) {
        this.useSalt = useSalt;
    }

    public void setSaltKeyLength(int saltKeyLength) {
        this.saltKeyLength = saltKeyLength;
    }
}

