/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.convert;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import vip.justlive.oxygen.core.util.MoreObjects;

public class ConverterTypePair {
    private static final Map<Integer, ConverterTypePair> CACHE = new ConcurrentHashMap<Integer, ConverterTypePair>(8);
    private final Class<?> sourceType;
    private final Class<?> targetType;

    private ConverterTypePair(Class<?> sourceType, Class<?> targetType) {
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    public static ConverterTypePair create(Class<?> sourceType, Class<?> targetType) {
        ConverterTypePair out;
        MoreObjects.notNull(sourceType, "Source type must not be null");
        MoreObjects.notNull(targetType, "Target type must not be null");
        Integer key = ConverterTypePair.hash(sourceType, targetType);
        ConverterTypePair pair = CACHE.get(key);
        if (pair == null && (out = CACHE.putIfAbsent(key, pair = new ConverterTypePair(sourceType, targetType))) != null) {
            return out;
        }
        return pair;
    }

    private static int hash(Class<?> sourceType, Class<?> targetType) {
        return sourceType.hashCode() * 31 + targetType.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != ConverterTypePair.class) {
            return false;
        }
        ConverterTypePair otherPair = (ConverterTypePair)other;
        return this.sourceType == otherPair.sourceType && this.targetType == otherPair.targetType;
    }

    public int hashCode() {
        return ConverterTypePair.hash(this.sourceType, this.targetType);
    }

    public String toString() {
        return this.sourceType.getName() + " -> " + this.targetType.getName();
    }
}

