/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.config;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import vip.justlive.oxygen.core.config.Binder;
import vip.justlive.oxygen.core.config.ValueConfig;
import vip.justlive.oxygen.core.io.PropertiesLoader;
import vip.justlive.oxygen.core.io.PropertySource;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.MoreObjects;

public class ConfigFactory {
    private static final Map<Class<?>, Map<String, Object>> FACTORY = new ConcurrentHashMap();
    private static final Properties PROPS = new Properties();
    private static final PropertySource SOURCE_WRAPPER = ConfigFactory::props;
    private static final Set<String> PARSED_LOCATIONS = new HashSet<String>(4);
    private static final Binder BINDER = new Binder(SOURCE_WRAPPER);

    private ConfigFactory() {
    }

    public static void loadProperties(String ... locations) {
        ConfigFactory.loadProperties(StandardCharsets.UTF_8, true, locations);
    }

    public static void loadProperties(Charset charset, boolean ignoreNotFound, String ... locations) {
        LinkedList<String> list = new LinkedList<String>();
        for (String location : locations) {
            if (!PARSED_LOCATIONS.add(location)) continue;
            list.add(location);
        }
        if (list.isEmpty()) {
            return;
        }
        PropertiesLoader loader = new PropertiesLoader(list.toArray(new String[0]));
        loader.setCharset(charset);
        loader.setIgnoreNotFound(ignoreNotFound);
        ConfigFactory.loadProperties(loader);
    }

    public static void loadProperties(PropertySource source) {
        PROPS.putAll((Map<?, ?>)source.props());
        FACTORY.clear();
    }

    public static void setProperty(String key, String value) {
        MoreObjects.notNull(key, "key can not be null");
        PROPS.setProperty(key, value);
        FACTORY.clear();
    }

    public static String getProperty(String key) {
        return SOURCE_WRAPPER.getProperty(key);
    }

    public static String getPlaceholderProperty(String placeholder) {
        return SOURCE_WRAPPER.getPlaceholderProperty(placeholder);
    }

    public static String getProperty(String key, String defaultValue) {
        return SOURCE_WRAPPER.getProperty(key, defaultValue);
    }

    public static <T> T load(Class<T> clazz) {
        return ConfigFactory.load(clazz, ".");
    }

    public static <T> T load(Class<T> clazz, String prefix) {
        Map map = FACTORY.computeIfAbsent(clazz, k -> new ConcurrentHashMap(4, 1.0f));
        if (map.containsKey(prefix)) {
            return clazz.cast(map.get(prefix));
        }
        Class<T> val = BINDER.bind(clazz, prefix);
        Class<T> other = map.putIfAbsent(prefix, val);
        if (other != null) {
            val = clazz.cast(other);
        }
        return (T)val;
    }

    public static void load(Object bean) {
        if (bean == null) {
            return;
        }
        ValueConfig config = ClassUtils.getAnnotation(ClassUtils.getCglibActualClass(bean.getClass()), ValueConfig.class);
        if (config == null) {
            ConfigFactory.load(bean, null);
        } else {
            ConfigFactory.load(bean, config.value());
        }
    }

    public static void load(Object bean, String prefix) {
        if (bean != null) {
            BINDER.bind(bean, prefix);
        }
    }

    public static void clear() {
        FACTORY.clear();
        PROPS.clear();
        PARSED_LOCATIONS.clear();
    }

    public static Set<String> keys() {
        return PROPS.stringPropertyNames();
    }

    private static Properties props() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)PROPS);
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }
}

