/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import vip.justlive.oxygen.core.cache.Cache;
import vip.justlive.oxygen.core.util.ExpiringMap;

public class LocalCacheImpl
implements Cache {
    private final String name;
    private final ExpiringMap<String, Object> expiringMap;

    public LocalCacheImpl(String name) {
        this.name = name;
        this.expiringMap = ExpiringMap.builder().name(name).build();
    }

    @Override
    public Object get(String key) {
        return this.expiringMap.get(key);
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return clazz.cast(this.get(key));
    }

    @Override
    public Map<String, Object> get(String ... keys) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        for (String key : keys) {
            map.put(key, this.get(key));
        }
        return map;
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        return this.expiringMap.putIfAbsent(key, value);
    }

    @Override
    public Object putIfAbsent(String key, Object value, long duration, TimeUnit unit) {
        return this.expiringMap.putIfAbsent(key, value, duration, unit);
    }

    @Override
    public Object set(String key, Object value) {
        return this.expiringMap.put(key, value);
    }

    @Override
    public Object set(String key, Object value, long duration, TimeUnit unit) {
        return this.expiringMap.put(key, value, duration, unit);
    }

    @Override
    public Object replace(String key, Object value) {
        return this.expiringMap.replace(key, value);
    }

    @Override
    public Object replace(String key, Object value, long duration, TimeUnit unit) {
        return this.expiringMap.replace(key, value, duration, unit);
    }

    @Override
    public Collection<String> keys() {
        return this.expiringMap.keySet();
    }

    @Override
    public void remove(String ... keys) {
        for (String key : keys) {
            this.expiringMap.remove(key);
        }
    }

    @Override
    public synchronized long incr(String key, int by) {
        Long value = this.get(key, Long.class);
        if (value == null) {
            value = by;
            this.set(key, value);
            return by;
        }
        value = value + (long)by;
        this.replace(key, value);
        return value;
    }

    @Override
    public void clear() {
        this.expiringMap.clear();
    }

    public String getName() {
        return this.name;
    }
}

