/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.cache;

import vip.justlive.oxygen.core.cache.Cache;
import vip.justlive.oxygen.core.cache.CacheFactory;
import vip.justlive.oxygen.core.cache.LocalCacheImpl;
import vip.justlive.oxygen.core.config.ConfigFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.Strings;

public class ClassCacheFactory
implements CacheFactory {
    @Override
    public Cache create(String name) {
        String cacheImpl = ConfigFactory.getProperty("cache.impl.class");
        if (Strings.hasText(cacheImpl)) {
            try {
                Class<?> clazz = ClassUtils.forName(cacheImpl);
                return (Cache)clazz.getConstructor(String.class).newInstance(name);
            }
            catch (Exception e) {
                throw Exceptions.wrap(e);
            }
        }
        return new LocalCacheImpl(name);
    }
}

