/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.cache;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import vip.justlive.oxygen.core.cache.CacheStore;

public interface Cache {
    public Object get(String var1);

    public <T> T get(String var1, Class<T> var2);

    public Map<String, Object> get(String ... var1);

    default public boolean exists(String key) {
        return this.get(key) != null;
    }

    public Object putIfAbsent(String var1, Object var2);

    public Object putIfAbsent(String var1, Object var2, long var3, TimeUnit var5);

    public Object set(String var1, Object var2);

    public Object set(String var1, Object var2, long var3, TimeUnit var5);

    public Object replace(String var1, Object var2);

    public Object replace(String var1, Object var2, long var3, TimeUnit var5);

    public Collection<String> keys();

    public void remove(String ... var1);

    default public long incr(String key) {
        return this.incr(key, 1);
    }

    public long incr(String var1, int var2);

    default public long decr(String key) {
        return this.decr(key, 1);
    }

    default public long decr(String key, int by) {
        return this.incr(key, -by);
    }

    public void clear();

    public static Cache cache() {
        return Cache.cache(Cache.class.getSimpleName());
    }

    public static Cache cache(String name) {
        if (!CacheStore.CACHES.containsKey(name)) {
            CacheStore.CACHES.putIfAbsent(name, CacheStore.createCache(name));
        }
        return CacheStore.CACHES.get(name);
    }

    public static Collection<String> cacheNames() {
        return CacheStore.CACHES.keySet();
    }

    public static void clearAll() {
        for (Cache cache : CacheStore.CACHES.values()) {
            cache.clear();
        }
        CacheStore.CACHES.clear();
    }
}

