/*
 * Decompiled with CFR 0.152.
 */
package us.springett.parsers.cpe.internal.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import us.springett.parsers.cpe.exceptions.CpeParsingException;

public class Cpe23PartIterator
implements Iterator<String> {
    private String cpe;
    private int pos;

    public Cpe23PartIterator(String cpe) throws CpeParsingException {
        if (cpe == null || !cpe.startsWith("cpe:2.3:")) {
            throw new CpeParsingException("Invalid 2.3 CPE value: " + cpe);
        }
        this.cpe = cpe;
        this.pos = 8;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.cpe.length();
    }

    @Override
    public String next() {
        int end;
        if (this.pos >= this.cpe.length()) {
            throw new NoSuchElementException("No remainging parts");
        }
        for (end = this.pos; end < this.cpe.length() && this.cpe.charAt(end) != ':'; ++end) {
            if (this.cpe.charAt(end) != '\\' || end + 1 >= this.cpe.length()) continue;
            ++end;
        }
        String part = this.cpe.substring(this.pos, end);
        this.pos = end + 1;
        return part;
    }
}

