/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.counts;

import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.loader.counts.TableRowCountsFilter;
import schemacrawler.loader.counts.TableRowCountsRetriever;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TaskRunner;
import us.fatehi.utility.scheduler.TaskRunners;

public class TableRowCountsCatalogLoader
extends BaseCatalogLoader {
    private static final Logger LOGGER = Logger.getLogger(TableRowCountsCatalogLoader.class.getName());
    private static final String OPTION_NO_EMPTY_TABLES = "no-empty-tables";
    private static final String OPTION_LOAD_ROW_COUNTS = "load-row-counts";

    public TableRowCountsCatalogLoader() {
        super(new CommandDescription("countsloader", "Loader for table row counts"), 2);
    }

    @Override
    public PluginCommand getCommandLineCommand() {
        CommandDescription commandDescription = this.getCommandDescription();
        PluginCommand pluginCommand = PluginCommand.newCatalogLoaderCommand(commandDescription.getName(), commandDescription.getDescription());
        pluginCommand.addOption(OPTION_LOAD_ROW_COUNTS, Boolean.class, "Loads row counts for each table", "This can be a time consuming operation", "Optional, defaults to false").addOption(OPTION_NO_EMPTY_TABLES, Boolean.class, "Includes only tables that have rows of data", "Requires table row counts to be loaded", "Optional, default is false");
        return pluginCommand;
    }

    @Override
    public void loadCatalog() {
        if (!this.isLoaded()) {
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving table row counts");
        try (TaskRunner taskRunner = TaskRunners.getTaskRunner("loadTableRowCounts", 1);){
            Catalog catalog = this.getCatalog();
            TableRowCountsRetriever rowCountsRetriever = new TableRowCountsRetriever(this.getDataSource(), catalog);
            Config config = this.getAdditionalConfiguration();
            taskRunner.add(new TaskDefinition("retrieveTableRowCounts", () -> {
                boolean loadRowCounts = config.getBooleanValue(OPTION_LOAD_ROW_COUNTS, false);
                if (loadRowCounts) {
                    rowCountsRetriever.retrieveTableRowCounts();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving table row counts, since this was not requested");
                }
            }));
            taskRunner.submit();
            taskRunner.add(new TaskDefinition("filterEmptyTables", () -> {
                boolean noEmptyTables = config.getBooleanValue(OPTION_NO_EMPTY_TABLES, false);
                catalog.reduce(Table.class, ReducerFactory.getTableReducer(new TableRowCountsFilter(noEmptyTables)));
            }));
            taskRunner.submit();
            LOGGER.log(Level.INFO, taskRunner.report());
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException("Exception retrieving table row counts", e);
        }
    }
}

