/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.string.StringFormat;

public final class CommandRegistry {
    private static final Logger LOGGER = Logger.getLogger(CommandRegistry.class.getName());
    private static CommandRegistry commandRegistrySingleton;
    public static final Comparator<? super CommandProvider> commandComparator;
    private final List<CommandProvider> commandRegistry = CommandRegistry.loadCommandRegistry();

    public static CommandRegistry getCommandRegistry() {
        if (commandRegistrySingleton == null) {
            commandRegistrySingleton = new CommandRegistry();
        }
        return commandRegistrySingleton;
    }

    private static List<CommandProvider> loadCommandRegistry() {
        ArrayList<CommandProvider> commandProviders = new ArrayList<CommandProvider>();
        try {
            ServiceLoader<CommandProvider> serviceLoader = ServiceLoader.load(CommandProvider.class, CommandRegistry.class.getClassLoader());
            for (CommandProvider commandProvider : serviceLoader) {
                LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Loading command %s, provided by %s", new Object[]{commandProvider.getSupportedCommands(), commandProvider.getClass().getName()}));
                commandProviders.add(commandProvider);
            }
        }
        catch (Throwable e) {
            throw new InternalRuntimeException("Could not load extended command registry", e);
        }
        return commandProviders;
    }

    private CommandRegistry() {
    }

    public SchemaCrawlerCommand<?> configureNewCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig, OutputOptions outputOptions) {
        SchemaCrawlerCommand<?> scCommand;
        ArrayList<CommandProvider> executableCommandProviders = new ArrayList<CommandProvider>();
        this.findSupportedCommands(command, schemaCrawlerOptions, additionalConfig, outputOptions, executableCommandProviders);
        this.findSupportedOutputFormats(command, outputOptions, executableCommandProviders);
        Collections.sort(executableCommandProviders, commandComparator);
        CommandProvider executableCommandProvider = (CommandProvider)executableCommandProviders.get(0);
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Matched provider <%s>", new Object[]{executableCommandProvider}));
        try {
            scCommand = executableCommandProvider.newSchemaCrawlerCommand(command, additionalConfig);
            if (scCommand == null) {
                throw new NullPointerException("No SchemaCrawler command instantiated");
            }
            scCommand.setSchemaCrawlerOptions(schemaCrawlerOptions);
            scCommand.setOutputOptions(outputOptions);
        }
        catch (ExecutionRuntimeException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Throwable e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
            throw new InternalRuntimeException(String.format("Cannot run command <%s>", command));
        }
        return scCommand;
    }

    public Collection<PluginCommand> getCommandLineCommands() {
        HashSet<PluginCommand> commandLineCommands = new HashSet<PluginCommand>();
        for (CommandProvider commandProvider : this.commandRegistry) {
            commandLineCommands.add(commandProvider.getCommandLineCommand());
        }
        return commandLineCommands;
    }

    public Collection<PluginCommand> getHelpCommands() {
        HashSet<PluginCommand> commandLineCommands = new HashSet<PluginCommand>();
        for (CommandProvider commandProvider : this.commandRegistry) {
            commandLineCommands.add(commandProvider.getHelpCommand());
        }
        return commandLineCommands;
    }

    public Collection<CommandDescription> getSupportedCommands() {
        HashSet<CommandDescription> supportedCommandDescriptions = new HashSet<CommandDescription>();
        for (CommandProvider commandProvider : this.commandRegistry) {
            supportedCommandDescriptions.addAll(commandProvider.getSupportedCommands());
        }
        ArrayList<CommandDescription> supportedCommandsOrdered = new ArrayList<CommandDescription>(supportedCommandDescriptions);
        supportedCommandsOrdered.sort(Comparator.naturalOrder());
        return supportedCommandsOrdered;
    }

    private void findSupportedCommands(String command, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig, OutputOptions outputOptions, List<CommandProvider> executableCommandProviders) {
        for (CommandProvider commandProvider : this.commandRegistry) {
            if (!commandProvider.supportsSchemaCrawlerCommand(command, schemaCrawlerOptions, additionalConfig, outputOptions)) continue;
            executableCommandProviders.add(commandProvider);
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Adding command-provider <%s>", new Object[]{commandProvider}));
        }
        if (executableCommandProviders.isEmpty()) {
            throw new ExecutionRuntimeException(String.format("Unknown command <%s>", command));
        }
    }

    private void findSupportedOutputFormats(String command, OutputOptions outputOptions, List<CommandProvider> executableCommandProviders) {
        Iterator<CommandProvider> iterator = executableCommandProviders.iterator();
        while (iterator.hasNext()) {
            CommandProvider executableCommandProvider = iterator.next();
            if (executableCommandProvider.supportsOutputFormat(command, outputOptions)) continue;
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Removing command-provider, since output format is not supported <%s>", new Object[]{executableCommandProvider}));
            iterator.remove();
        }
        if (executableCommandProviders.isEmpty()) {
            throw new ConfigurationException(String.format("Output format <%s> not supported for command <%s>", outputOptions.getOutputFormatValue(), command));
        }
    }

    static {
        commandComparator = (commandProvider1, commandProvider2) -> {
            String typeName2;
            String fallbackProviderTypeName = "OperationCommandProvider";
            if (commandProvider1 == null || commandProvider2 == null) {
                throw new IllegalArgumentException("Null command provider found");
            }
            String typeName1 = commandProvider1.getClass().getSimpleName();
            if (typeName1.equals(typeName2 = commandProvider2.getClass().getSimpleName())) {
                return 0;
            }
            if (typeName1.equals("OperationCommandProvider")) {
                return 1;
            }
            if (typeName2.equals("OperationCommandProvider")) {
                return -1;
            }
            return typeName1.compareTo(typeName2);
        };
    }
}

