/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.table;

import java.util.Collection;
import uk.org.retep.table.Cell;
import uk.org.retep.table.Header;
import uk.org.retep.table.Row;
import uk.org.retep.table.Table;
import uk.org.retep.util.string.StringUtils;

public class TableRenderer {
    private TableRenderer() {
    }

    public static String renderTable(Table table) {
        StringBuilder out = new StringBuilder();
        TableRenderer.appendTable(out, table);
        return out.toString();
    }

    public static StringBuilder appendTable(StringBuilder out, Table table) {
        table.fixTable();
        switch (table.getSortable()) {
            case TRUE: {
                out.append("<div class=\"dataGridHeader\"");
                if (StringUtils.isStringNotEmpty((String)table.getStyle())) {
                    out.append(" style=\"").append(table.getStyle()).append('\"');
                }
                out.append("><div class=\"dataGridContent\"");
                break;
            }
        }
        out.append("<table cellpadding=\"0\" cellspacing=\"0\"");
        switch (table.getSortable()) {
            case TRUE: {
                out.append(" class=\"scrolltablestyle style-even");
                if (StringUtils.isStringNotEmpty((String)table.getStyleClass())) {
                    out.append(' ').append(table.getStyleClass());
                }
                out.append('\"');
                break;
            }
            case FALSE: 
            case DEFAULT: {
                if (!StringUtils.isStringNotEmpty((String)table.getStyleClass())) break;
                out.append(" class=\"").append(table.getStyleClass()).append('\"');
            }
        }
        if (StringUtils.isStringNotEmpty((String)table.getStyle())) {
            out.append(" style=\"").append(table.getStyle()).append("\"");
        }
        if (StringUtils.isStringNotEmpty((String)table.getId())) {
            out.append(" id=\"").append(table.getId()).append("\"");
        }
        out.append(">\n");
        Collection<Header> headers = table.getHeaders();
        if (!headers.isEmpty()) {
            out.append("<thead><tr>");
            for (Header header : table.getHeaders()) {
                if (!header.containsContent()) continue;
                out.append("<th");
                if (StringUtils.isStringNotEmpty((String)header.getWidth())) {
                    out.append(" width=\"").append(header.getWidth()).append("\"");
                }
                boolean sortable = header.isSortable();
                boolean addClass = false;
                if (sortable) {
                    out.append(" class=\"sortable");
                    addClass = true;
                }
                if (StringUtils.isStringNotEmpty((String)header.getStyleClass())) {
                    if (addClass) {
                        out.append(' ');
                    }
                    out.append(header.getStyleClass());
                    addClass = true;
                }
                if (addClass) {
                    out.append("\"");
                }
                if (StringUtils.isStringNotEmpty((String)header.getStyle())) {
                    out.append(" style=\"").append(header.getStyle()).append("\"");
                }
                TableRenderer.cellAlignment(out, header);
                TableRenderer.cellSpan(out, header);
                out.append(">");
                if (sortable) {
                    out.append("<a href=\"#\">");
                }
                out.append(header.getValue());
                if (sortable) {
                    out.append("</a>");
                }
                out.append("</th>");
            }
            out.append("</tr></thead>\n");
        }
        out.append("<tbody>\n");
        for (Row row : table.getRows()) {
            out.append("<tr>");
            for (Cell cell : row) {
                if (!cell.containsContent()) continue;
                Header header = table.getHeader(cell.getIndex());
                out.append("<td");
                if (header != null && StringUtils.isStringNotEmpty((String)header.getWidth())) {
                    out.append(" width=\"").append(header.getWidth()).append("\"");
                }
                if (StringUtils.isStringNotEmpty((String)cell.getStyle())) {
                    out.append(" style=\"").append(cell.getStyle()).append("\"");
                }
                if (StringUtils.isStringNotEmpty((String)cell.getStyleClass())) {
                    out.append(" class=\"").append(cell.getStyleClass()).append("\"");
                }
                TableRenderer.cellAlignment(out, cell);
                TableRenderer.cellSpan(out, cell);
                out.append(">").append(cell.getValue()).append("</td>");
            }
            out.append("</tr>\n");
        }
        out.append("</tbody>\n");
        out.append("</table>\n");
        switch (table.getSortable()) {
            case TRUE: {
                out.append("</div></div>");
                break;
            }
        }
        return out;
    }

    private static void cellSpan(StringBuilder out, Cell cell) {
        if (cell.getRowSpan() > 1) {
            out.append(" rowspan=\"").append(cell.getRowSpan()).append('\"');
        }
        if (cell.getColSpan() > 1) {
            out.append(" colspan=\"").append(cell.getColSpan()).append('\"');
        }
    }

    private static void cellAlignment(StringBuilder out, Cell cell) {
        switch (cell.getTextAlignment()) {
            case LEFT: {
                break;
            }
            case RIGHT: {
                out.append(" align=\"right\"");
                break;
            }
            case CENTER: 
            case CENTRE: {
                out.append(" align=\"center\"");
                break;
            }
        }
    }
}

