/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.org.retep.table.Cell;
import uk.org.retep.table.Header;
import uk.org.retep.table.Row;
import uk.org.retep.util.state.TriState;

public class Table
implements Serializable {
    static final long serialVersionUID = -6119007321054010324L;
    private String id;
    private String styleClass;
    private String style;
    private TriState sortable = TriState.FALSE;
    private List<Header> headers;
    private List<Row> rows;

    public Table() {
        this(TriState.FALSE, null);
    }

    public Table(TriState sortable) {
        this(sortable, null);
    }

    public Table(String style) {
        this(TriState.FALSE, style);
    }

    public Table(TriState sortable, String style) {
        this.sortable = sortable;
        this.style = style;
        this.headers = new ArrayList<Header>();
        this.rows = new ArrayList<Row>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isSortable() {
        return this.sortable.booleanValue();
    }

    public TriState getSortable() {
        return this.sortable;
    }

    public void setSortable(TriState sortable) {
        this.sortable = sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = TriState.valueOf((boolean)sortable);
    }

    public void addHeader(Header header) {
        this.headers.add(header);
        header.setTable(this);
    }

    public void setHeader(int index, Header header) {
        this.headers.set(index, header);
        header.setTable(this);
    }

    public Header getHeader(int index) {
        return index < 0 || index >= this.headers.size() ? null : this.headers.get(index);
    }

    public int getHeaderCount() {
        return this.headers.size();
    }

    public Collection<Header> getHeaders() {
        return this.headers;
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void setRow(int index, Row row) {
        this.rows.set(index, row);
    }

    public Row getRow(int index) {
        return this.rows.get(index);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Collection<Row> getRows() {
        return this.rows;
    }

    public void fixTable() {
        this.fixRow(this.getHeaders(), false);
        for (Row row : this.getRows()) {
            this.fixRow(row, true);
        }
    }

    private void fixRow(Collection<? extends Cell> cells, boolean isCell) {
        if (cells == null || cells.isEmpty()) {
            return;
        }
        Cell goodCell = null;
        for (Cell cell : cells) {
            if (goodCell == null) {
                goodCell = cell;
                cell.setColSpan(0);
                cell.setRowSpan(0);
                continue;
            }
            if (cell.isMergeLeft()) {
                goodCell.setColSpan(goodCell.getColSpan() + 1);
                continue;
            }
            if (isCell && cell.isMergeAbove()) {
                Cell aboveCell = this.locateAboveCell(cells, cell);
                if (aboveCell == null) continue;
                aboveCell.setRowSpan(aboveCell.getRowSpan() + 1);
                continue;
            }
            goodCell = cell;
        }
    }

    private Cell locateAboveCell(Collection<? extends Cell> row, Cell child) {
        int childIndex = child.getIndex();
        int rowIndex = this.rows.indexOf(row);
        if (rowIndex > 1) {
            while (--rowIndex > 0) {
                Row parentRow = this.rows.get(rowIndex);
                Cell parentCell = (Cell)parentRow.get(childIndex);
                if (parentCell == null || parentCell.isMergeAbove()) continue;
                return parentCell;
            }
        }
        return null;
    }
}

