/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongIterator;

public final class LongHashSet
extends AbstractSet<Long> {
    public static final float DEFAULT_LOAD_FACTOR = 0.67f;
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    static final long MISSING_VALUE = -1L;
    private final float loadFactor;
    private int resizeThreshold;
    private int sizeOfArrayValues;
    private long[] values;
    private final LongIterator iterator = new LongHashSetIterator();
    private boolean containsMissingValue;

    public LongHashSet() {
        this(8);
    }

    public LongHashSet(int proposedCapacity) {
        this(proposedCapacity, 0.67f);
    }

    public LongHashSet(int initialCapacity, float loadFactor) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.sizeOfArrayValues = 0;
        int capacity = BitUtil.findNextPositivePowerOfTwo(initialCapacity);
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.values = new long[capacity];
        Arrays.fill(this.values, -1L);
    }

    @Override
    public boolean add(Long value) {
        return this.add((long)value);
    }

    @Override
    public boolean add(long value) {
        if (value == -1L) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = true;
            return !previousContainsMissingValue;
        }
        long[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1L) {
            if (values[index] == value) {
                return false;
            }
            index = LongHashSet.next(index, mask);
        }
        values[index] = value;
        ++this.sizeOfArrayValues;
        if (this.sizeOfArrayValues > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length * 2;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size());
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int capacity = newCapacity;
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        long[] tempValues = new long[capacity];
        Arrays.fill(tempValues, -1L);
        for (long value : this.values) {
            if (value == -1L) continue;
            int newHash = Hashing.hash(value, mask);
            while (tempValues[newHash] != -1L) {
                ++newHash;
                newHash &= mask;
            }
            tempValues[newHash] = value;
        }
        this.values = tempValues;
    }

    @Override
    public boolean remove(Object value) {
        return value instanceof Long && this.remove((Long)value);
    }

    public boolean remove(long value) {
        if (value == -1L) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = false;
            return previousContainsMissingValue;
        }
        long[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1L) {
            if (values[index] == value) {
                values[index] = -1L;
                this.compactChain(index);
                --this.sizeOfArrayValues;
                return true;
            }
            index = LongHashSet.next(index, mask);
        }
        return false;
    }

    private static int next(int index, int mask) {
        return index + 1 & mask;
    }

    void compactChain(int deleteIndex) {
        long[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        while (values[index = LongHashSet.next(index, mask)] != -1L) {
            int hash = Hashing.hash(values[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            values[deleteIndex] = values[index];
            values[index] = -1L;
            deleteIndex = index;
        }
        return;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(idealCapacity));
    }

    @Override
    public boolean contains(Object value) {
        return value instanceof Long && this.contains((Long)value);
    }

    public boolean contains(long value) {
        if (value == -1L) {
            return this.containsMissingValue;
        }
        long[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1L) {
            if (values[index] == value) {
                return true;
            }
            index = LongHashSet.next(index, mask);
        }
        return false;
    }

    @Override
    public int size() {
        return this.sizeOfArrayValues + (this.containsMissingValue ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public long capacity() {
        return this.values.length;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, -1L);
        this.sizeOfArrayValues = 0;
    }

    @Override
    public boolean addAll(Collection<? extends Long> coll) {
        return LongHashSet.disjunction(coll, this::add);
    }

    public boolean addAll(LongHashSet coll) {
        boolean acc = false;
        for (long value : coll.values) {
            if (value == -1L) continue;
            acc |= this.add(value);
        }
        return acc;
    }

    public boolean containsAll(LongHashSet other) {
        for (long value : other.values) {
            if (value == -1L || this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public LongHashSet difference(LongHashSet other) {
        LongHashSet difference = null;
        for (long value : this.values) {
            if (value == -1L || other.contains(value)) continue;
            if (difference == null) {
                difference = new LongHashSet(this.sizeOfArrayValues);
            }
            difference.add(value);
        }
        return difference;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return LongHashSet.disjunction(coll, this::remove);
    }

    public boolean removeAll(LongHashSet coll) {
        boolean acc = false;
        for (long value : coll.values) {
            if (value == -1L) continue;
            acc |= this.remove(value);
        }
        return acc;
    }

    private static <T> boolean disjunction(Collection<T> coll, Predicate<T> predicate) {
        boolean acc = false;
        for (T t : coll) {
            acc |= predicate.test(t);
        }
        return acc;
    }

    public LongIterator iterator() {
        this.iterator.reset(this.values, this.containsMissingValue);
        return this.iterator;
    }

    public void copy(LongHashSet that) {
        if (this.values.length != that.values.length) {
            throw new IllegalArgumentException("Cannot copy object: masks not equal");
        }
        System.arraycopy(that.values, 0, this.values, 0, this.values.length);
        this.sizeOfArrayValues = that.sizeOfArrayValues;
    }

    @Override
    public String toString() {
        return this.stream().map(x -> Long.toString(x)).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    public <T> T[] toArray(T[] longo) {
        Class<Long> componentType = longo.getClass().getComponentType();
        if (!componentType.isAssignableFrom(Long.class)) {
            throw new ArrayStoreException("Cannot store Longs in array of type " + componentType);
        }
        int size = this.size();
        Object[] arrayCopy = longo.length >= size ? longo : (Object[])Array.newInstance(componentType, size);
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    @Override
    public Object[] toArray() {
        Object[] arrayCopy = new Object[this.size()];
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    private void copyValues(Object[] arrayCopy) {
        LongIterator iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            arrayCopy[i] = iterator.next();
            ++i;
        }
        if (this.containsMissingValue) {
            arrayCopy[this.sizeOfArrayValues] = -1L;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof LongHashSet) {
            LongHashSet otherSet = (LongHashSet)other;
            return otherSet.containsMissingValue == this.containsMissingValue && otherSet.sizeOfArrayValues == this.sizeOfArrayValues && this.containsAll(otherSet);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (long value : this.values) {
            if (value == -1L) continue;
            hashCode = 31 * hashCode + Hashing.hash(value);
        }
        hashCode = 31 * hashCode + (this.containsMissingValue ? 1 : 0);
        return hashCode;
    }

    public final class LongHashSetIterator
    extends LongIterator {
        @Override
        public void remove() {
            if (this.isPositionValid) {
                int position = this.position();
                ((LongHashSet)LongHashSet.this).values[position] = -1L;
                --LongHashSet.this.sizeOfArrayValues;
                LongHashSet.this.compactChain(position);
                this.isPositionValid = false;
            } else if (LongHashSet.this.containsMissingValue) {
                LongHashSet.this.containsMissingValue = false;
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

