/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIterator;

public final class IntHashSet
extends AbstractSet<Integer> {
    public static final float DEFAULT_LOAD_FACTOR = 0.67f;
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    static final int MISSING_VALUE = -1;
    private final float loadFactor;
    private int resizeThreshold;
    private int sizeOfArrayValues;
    private int[] values;
    private final IntIterator iterator = new IntHashSetIterator();
    private boolean containsMissingValue;

    public IntHashSet() {
        this(8);
    }

    public IntHashSet(int proposedCapacity) {
        this(proposedCapacity, 0.67f);
    }

    public IntHashSet(int initialCapacity, float loadFactor) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.sizeOfArrayValues = 0;
        int capacity = BitUtil.findNextPositivePowerOfTwo(initialCapacity);
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.values = new int[capacity];
        Arrays.fill(this.values, -1);
    }

    @Override
    public boolean add(Integer value) {
        return this.add((int)value);
    }

    @Override
    public boolean add(int value) {
        if (value == -1) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = true;
            return !previousContainsMissingValue;
        }
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1) {
            if (values[index] == value) {
                return false;
            }
            index = IntHashSet.next(index, mask);
        }
        values[index] = value;
        ++this.sizeOfArrayValues;
        if (this.sizeOfArrayValues > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length * 2;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size());
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int capacity = newCapacity;
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        int[] tempValues = new int[capacity];
        Arrays.fill(tempValues, -1);
        for (int value : this.values) {
            if (value == -1) continue;
            int newHash = Hashing.hash(value, mask);
            while (tempValues[newHash] != -1) {
                ++newHash;
                newHash &= mask;
            }
            tempValues[newHash] = value;
        }
        this.values = tempValues;
    }

    @Override
    public boolean remove(Object value) {
        return value instanceof Integer && this.remove((Integer)value);
    }

    public boolean remove(int value) {
        if (value == -1) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = false;
            return previousContainsMissingValue;
        }
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1) {
            if (values[index] == value) {
                values[index] = -1;
                this.compactChain(index);
                --this.sizeOfArrayValues;
                return true;
            }
            index = IntHashSet.next(index, mask);
        }
        return false;
    }

    private static int next(int index, int mask) {
        return index + 1 & mask;
    }

    void compactChain(int deleteIndex) {
        int[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        while (values[index = IntHashSet.next(index, mask)] != -1) {
            int hash = Hashing.hash(values[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            values[deleteIndex] = values[index];
            values[index] = -1;
            deleteIndex = index;
        }
        return;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(idealCapacity));
    }

    @Override
    public boolean contains(Object value) {
        return value instanceof Integer && this.contains((Integer)value);
    }

    public boolean contains(int value) {
        if (value == -1) {
            return this.containsMissingValue;
        }
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1) {
            if (values[index] == value) {
                return true;
            }
            index = IntHashSet.next(index, mask);
        }
        return false;
    }

    @Override
    public int size() {
        return this.sizeOfArrayValues + (this.containsMissingValue ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, -1);
        this.sizeOfArrayValues = 0;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> coll) {
        return IntHashSet.disjunction(coll, this::add);
    }

    public boolean addAll(IntHashSet coll) {
        boolean acc = false;
        for (int value : coll.values) {
            if (value == -1) continue;
            acc |= this.add(value);
        }
        return acc;
    }

    public boolean containsAll(IntHashSet other) {
        for (int value : other.values) {
            if (value == -1 || this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public IntHashSet difference(IntHashSet other) {
        IntHashSet difference = null;
        for (int value : this.values) {
            if (value == -1 || other.contains(value)) continue;
            if (difference == null) {
                difference = new IntHashSet(this.sizeOfArrayValues);
            }
            difference.add(value);
        }
        return difference;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return IntHashSet.disjunction(coll, this::remove);
    }

    public boolean removeAll(IntHashSet coll) {
        boolean acc = false;
        for (int value : coll.values) {
            if (value == -1) continue;
            acc |= this.remove(value);
        }
        return acc;
    }

    private static <T> boolean disjunction(Collection<T> coll, Predicate<T> predicate) {
        boolean acc = false;
        for (T t : coll) {
            acc |= predicate.test(t);
        }
        return acc;
    }

    public IntIterator iterator() {
        this.iterator.reset(this.values, this.containsMissingValue);
        return this.iterator;
    }

    public void copy(IntHashSet that) {
        if (this.values.length != that.values.length) {
            throw new IllegalArgumentException("Cannot copy object: masks not equal");
        }
        System.arraycopy(that.values, 0, this.values, 0, this.values.length);
        this.sizeOfArrayValues = that.sizeOfArrayValues;
    }

    @Override
    public String toString() {
        return this.stream().map(x -> Integer.toString(x)).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    public <T> T[] toArray(T[] into) {
        Class<Integer> componentType = into.getClass().getComponentType();
        if (!componentType.isAssignableFrom(Integer.class)) {
            throw new ArrayStoreException("Cannot store Integers in array of type " + componentType);
        }
        int size = this.size();
        Object[] arrayCopy = into.length >= size ? into : (Object[])Array.newInstance(componentType, size);
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    @Override
    public Object[] toArray() {
        Object[] arrayCopy = new Object[this.size()];
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    private void copyValues(Object[] arrayCopy) {
        IntIterator iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            arrayCopy[i] = iterator.next();
            ++i;
        }
        if (this.containsMissingValue) {
            arrayCopy[this.sizeOfArrayValues] = -1;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IntHashSet) {
            IntHashSet otherSet = (IntHashSet)other;
            return otherSet.containsMissingValue == this.containsMissingValue && otherSet.sizeOfArrayValues == this.sizeOfArrayValues && this.containsAll(otherSet);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (int value : this.values) {
            if (value == -1) continue;
            hashCode = 31 * hashCode + Hashing.hash(value);
        }
        hashCode = 31 * hashCode + (this.containsMissingValue ? 1 : 0);
        return hashCode;
    }

    public final class IntHashSetIterator
    extends IntIterator {
        @Override
        public void remove() {
            if (this.isPositionValid) {
                int position = this.position();
                ((IntHashSet)IntHashSet.this).values[position] = -1;
                --IntHashSet.this.sizeOfArrayValues;
                IntHashSet.this.compactChain(position);
                this.isPositionValid = false;
            } else if (IntHashSet.this.containsMissingValue) {
                IntHashSet.this.containsMissingValue = false;
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

