/*
 * Decompiled with CFR 0.152.
 */
package xitrum.view;

import com.codahale.jerkson.Json$;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.Xhtml$;
import xitrum.Config$;
import xitrum.Controller;
import xitrum.controller.Action;
import xitrum.etag.NotModified$;
import xitrum.handler.down.XSendFile$;
import xitrum.handler.down.XSendResource$;
import xitrum.handler.up.NoPipelining$;
import xitrum.routing.Routes$;
import xitrum.scope.request.RequestEnv;
import xitrum.view.Scalate$;

public abstract class Responder$class {
    public static boolean isResponded(Controller $this) {
        return $this.xitrum$view$Responder$$responded();
    }

    /*
     * WARNING - void declaration
     */
    public static ChannelFuture respond(Controller $this) {
        ChannelFuture channelFuture;
        if ($this.xitrum$view$Responder$$responded()) {
            channelFuture = Responder$class.printDoubleResponseErrorStackTrace($this);
        } else {
            void var1_1;
            $this.xitrum$view$Responder$$responded_$eq(true);
            NoPipelining$.MODULE$.setResponseHeaderForKeepAliveRequest(((RequestEnv)((Object)$this)).request(), ((RequestEnv)((Object)$this)).response());
            $this.setCookieAndSessionIfTouchedOnRespond();
            ChannelFuture future = ((RequestEnv)((Object)$this)).channel().write((Object)((RequestEnv)((Object)$this)).handlerEnv());
            if (!XSendFile$.MODULE$.isHeaderSet(((RequestEnv)((Object)$this)).response()) && !XSendResource$.MODULE$.isHeaderSet(((RequestEnv)((Object)$this)).response())) {
                NoPipelining$.MODULE$.resumeReadingForKeepAliveRequestOrCloseOnComplete(((RequestEnv)((Object)$this)).request(), ((RequestEnv)((Object)$this)).channel(), future);
            }
            channelFuture = var1_1;
        }
        return channelFuture;
    }

    private static ChannelFuture writeHeaderIfFirstChunk(Controller $this) {
        ChannelFuture channelFuture;
        if ($this.xitrum$view$Responder$$responded()) {
            channelFuture = Responder$class.printDoubleResponseErrorStackTrace($this);
        } else {
            if (!((RequestEnv)((Object)$this)).response().containsHeader("Content-Type")) {
                ((RequestEnv)((Object)$this)).response().setHeader("Content-Type", (Object)"application/octet-stream");
            }
            ((RequestEnv)((Object)$this)).response().setHeader("Transfer-Encoding", (Object)"chunked");
            $this.setNoClientCache();
            ((RequestEnv)((Object)$this)).response().removeHeader("Content-Length");
            channelFuture = $this.respond();
        }
        return channelFuture;
    }

    /*
     * WARNING - void declaration
     */
    public static ChannelFuture respondLastChunk(Controller $this) {
        ChannelFuture channelFuture;
        if ($this.xitrum$view$Responder$$responded()) {
            channelFuture = Responder$class.printDoubleResponseErrorStackTrace($this);
        } else {
            void var1_1;
            $this.xitrum$view$Responder$$responded_$eq(true);
            ChannelFuture future = ((RequestEnv)((Object)$this)).channel().write((Object)HttpChunk.LAST_CHUNK);
            NoPipelining$.MODULE$.resumeReadingForKeepAliveRequestOrCloseOnComplete(((RequestEnv)((Object)$this)).request(), ((RequestEnv)((Object)$this)).channel(), future);
            channelFuture = var1_1;
        }
        return channelFuture;
    }

    public static ChannelFuture respondText(Controller $this, Object text, String contentType) {
        ChannelFuture channelFuture;
        String respondedText;
        boolean textIsXml;
        boolean bl = textIsXml = text instanceof Node || text instanceof NodeSeq;
        String string = textIsXml ? (text instanceof Node ? Xhtml$.MODULE$.toXhtml((Node)text) : Xhtml$.MODULE$.toXhtml((NodeSeq)text)) : (respondedText = text.toString());
        if (!$this.xitrum$view$Responder$$responded()) {
            if (contentType == null) {
                if (!((RequestEnv)((Object)$this)).response().containsHeader("Content-Type")) {
                    if (textIsXml) {
                        ((RequestEnv)((Object)$this)).response().setHeader("Content-Type", (Object)new StringBuilder().append((Object)"application/xml; charset=").append((Object)Config$.MODULE$.config().request().charset()).toString());
                    } else {
                        ((RequestEnv)((Object)$this)).response().setHeader("Content-Type", (Object)new StringBuilder().append((Object)"text/plain; charset=").append((Object)Config$.MODULE$.config().request().charset()).toString());
                    }
                }
            } else {
                ((RequestEnv)((Object)$this)).response().setHeader("Content-Type", (Object)contentType);
            }
        }
        ChannelBuffer cb = ChannelBuffers.copiedBuffer((CharSequence)respondedText, (Charset)Config$.MODULE$.requestCharset());
        if (((RequestEnv)((Object)$this)).response().isChunked()) {
            Responder$class.writeHeaderIfFirstChunk($this);
            channelFuture = ((RequestEnv)((Object)$this)).channel().write((Object)new DefaultHttpChunk(cb));
        } else {
            HttpHeaders.setContentLength((HttpMessage)((RequestEnv)((Object)$this)).response(), (long)cb.readableBytes());
            ((RequestEnv)((Object)$this)).response().setContent(cb);
            channelFuture = $this.respond();
        }
        return channelFuture;
    }

    public static String respondText$default$2(Controller $this) {
        return null;
    }

    public static ChannelFuture respondHtml(Controller $this, Object any) {
        return $this.respondText(any, new StringBuilder().append((Object)"text/html; charset=").append((Object)Config$.MODULE$.config().request().charset()).toString());
    }

    public static ChannelFuture respondJs(Controller $this, Object any) {
        return $this.respondText(any, new StringBuilder().append((Object)"application/javascript; charset=").append((Object)Config$.MODULE$.config().request().charset()).toString());
    }

    public static ChannelFuture respondJsonText(Controller $this, Object any) {
        return $this.respondText(any, new StringBuilder().append((Object)"application/json; charset=").append((Object)Config$.MODULE$.config().request().charset()).toString());
    }

    public static ChannelFuture respondJson(Controller $this, Object obj) {
        String json = Json$.MODULE$.generate(obj);
        return $this.respondText(json, new StringBuilder().append((Object)"application/json; charset=").append((Object)Config$.MODULE$.config().request().charset()).toString());
    }

    public static ChannelFuture respondJsonP(Controller $this, Object obj, String function) {
        String json = Json$.MODULE$.generate(obj);
        String text = new StringBuilder().append((Object)function).append((Object)"(").append((Object)json).append((Object)")").toString();
        return $this.respondJs(text);
    }

    public static ChannelFuture respondJsonPText(Controller $this, Object any, String function) {
        String text = new StringBuilder().append((Object)function).append((Object)"(").append(any).append((Object)")").toString();
        return $this.respondJs(text);
    }

    public static Object layout(Controller $this) {
        return $this.renderedView();
    }

    public static ChannelFuture respondInlineView(Controller $this, Object view) {
        return $this.respondInlineView(view, (Function0<Object>)new Serializable($this){
            public static final long serialVersionUID;
            private final Controller $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply() {
                return this.$outer.layout();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static ChannelFuture respondInlineView(Controller $this, Object view, Function0 customLayout) {
        $this.renderedView_$eq(view);
        Object respondedLayout = customLayout.apply();
        return respondedLayout == null ? $this.respondText($this.renderedView(), new StringBuilder().append((Object)"text/html; charset=").append((Object)Config$.MODULE$.config().request().charset()).toString()) : $this.respondText(respondedLayout, new StringBuilder().append((Object)"text/html; charset=").append((Object)Config$.MODULE$.config().request().charset()).toString());
    }

    public static String renderScalate(Controller $this, String relPath) {
        return Scalate$.MODULE$.renderFile($this, relPath);
    }

    public static String renderScalate(Controller $this, Class controllerClass, String templateType) {
        String relPath = new StringBuilder().append((Object)controllerClass.getName().replace('.', File.separatorChar)).append((Object)".").append((Object)templateType).toString();
        return $this.renderScalate(relPath);
    }

    public static String renderScalate(Controller $this, Class controllerClass) {
        return $this.renderScalate(controllerClass, Config$.MODULE$.config().scalate());
    }

    public static String renderFragment(Controller $this, Class controllerClass, String fragment, String templateType) {
        String relPath = new StringBuilder().append((Object)controllerClass.getName().replace('.', File.separatorChar)).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).append((Object)"_").append((Object)fragment).append((Object)".").append((Object)templateType).toString();
        return $this.renderScalate(relPath);
    }

    public static String renderFragment(Controller $this, Class controllerClass, String fragment) {
        return $this.renderFragment(controllerClass, fragment, Config$.MODULE$.config().scalate());
    }

    public static ChannelFuture respondView(Controller $this, Action action, Function0 customLayout, String templateType) {
        Method nonNullActionMethod = action.method() == null ? Routes$.MODULE$.lookupMethod(action.route()) : action.method();
        Class<?> controllerClass = nonNullActionMethod.getDeclaringClass();
        String actionName = nonNullActionMethod.getName();
        String relPath = new StringBuilder().append((Object)controllerClass.getName().replace('.', File.separatorChar)).append((Object)File.separator).append((Object)actionName).append((Object)".").append((Object)templateType).toString();
        $this.renderedView_$eq($this.renderScalate(relPath));
        Object respondedLayout = customLayout.apply();
        return respondedLayout == null ? $this.respondText($this.renderedView(), new StringBuilder().append((Object)"text/html; charset=").append((Object)Config$.MODULE$.config().request().charset()).toString()) : $this.respondText(respondedLayout, new StringBuilder().append((Object)"text/html; charset=").append((Object)Config$.MODULE$.config().request().charset()).toString());
    }

    public static ChannelFuture respondView(Controller $this, Action action, Function0 customLayout) {
        return $this.respondView(action, (Function0<Object>)customLayout, Config$.MODULE$.config().scalate());
    }

    public static ChannelFuture respondView(Controller $this, Action action, String templateType) {
        return $this.respondView(action, (Function0<Object>)new Serializable($this){
            public static final long serialVersionUID;
            private final Controller $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply() {
                return this.$outer.layout();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, templateType);
    }

    public static ChannelFuture respondView(Controller $this, String templateType) {
        return $this.respondView($this.currentAction(), templateType);
    }

    public static ChannelFuture respondView(Controller $this, Action action) {
        return $this.respondView(action, (Function0<Object>)new Serializable($this){
            public static final long serialVersionUID;
            private final Controller $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply() {
                return this.$outer.layout();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Config$.MODULE$.config().scalate());
    }

    public static ChannelFuture respondView(Controller $this) {
        return $this.respondView($this.currentAction(), Config$.MODULE$.config().scalate());
    }

    public static ChannelFuture respondBinary(Controller $this, byte[] bytes) {
        return $this.respondBinary(ChannelBuffers.wrappedBuffer((byte[])bytes));
    }

    public static ChannelFuture respondBinary(Controller $this, ChannelBuffer channelBuffer) {
        ChannelFuture channelFuture;
        if (((RequestEnv)((Object)$this)).response().isChunked()) {
            Responder$class.writeHeaderIfFirstChunk($this);
            channelFuture = ((RequestEnv)((Object)$this)).channel().write((Object)new DefaultHttpChunk(channelBuffer));
        } else {
            if (!((RequestEnv)((Object)$this)).response().containsHeader("Content-Type")) {
                ((RequestEnv)((Object)$this)).response().setHeader("Content-Type", (Object)"application/octet-stream");
            }
            HttpHeaders.setContentLength((HttpMessage)((RequestEnv)((Object)$this)).response(), (long)channelBuffer.readableBytes());
            ((RequestEnv)((Object)$this)).response().setContent(channelBuffer);
            channelFuture = $this.respond();
        }
        return channelFuture;
    }

    public static ChannelFuture respondFile(Controller $this, String path) {
        XSendFile$.MODULE$.setHeader(((RequestEnv)((Object)$this)).response(), path);
        return $this.respond();
    }

    public static ChannelFuture respondResource(Controller $this, String path) {
        XSendResource$.MODULE$.setHeader(((RequestEnv)((Object)$this)).response(), path);
        return $this.respond();
    }

    public static ChannelFuture respondDefault404Page(Controller $this) {
        XSendFile$.MODULE$.set404Page(((RequestEnv)((Object)$this)).response());
        return $this.respond();
    }

    public static ChannelFuture respondDefault500Page(Controller $this) {
        XSendFile$.MODULE$.set500Page(((RequestEnv)((Object)$this)).response());
        return $this.respond();
    }

    public static ChannelFuture respondWebSocket(Controller $this, String text) {
        return ((RequestEnv)((Object)$this)).channel().write((Object)new TextWebSocketFrame(text));
    }

    public static ChannelFuture respondWebSocket(Controller $this, ChannelBuffer channelBuffer) {
        return ((RequestEnv)((Object)$this)).channel().write((Object)new TextWebSocketFrame(channelBuffer));
    }

    public static void setClientCacheAggressively(Controller $this) {
        NotModified$.MODULE$.setClientCacheAggressively(((RequestEnv)((Object)$this)).response());
    }

    public static void setNoClientCache(Controller $this) {
        NotModified$.MODULE$.setNoClientCache(((RequestEnv)((Object)$this)).response());
    }

    private static ChannelFuture printDoubleResponseErrorStackTrace(Controller $this) {
        try {
            throw new Exception();
        }
        catch (Throwable throwable) {
            $this.logger().warn("Double response! This response is ignored.", throwable);
            return null;
        }
    }

    public static void $init$(Controller $this) {
        $this.xitrum$view$Responder$$responded_$eq(false);
        $this.renderedView_$eq(null);
    }
}

