/*
 * Decompiled with CFR 0.152.
 */
package xitrum.util;

import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPOutputStream;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import scala.ScalaObject;
import xitrum.Config$;
import xitrum.util.ChannelBufferToBytes$;
import xitrum.util.Mime$;

public final class Gzip$
implements ScalaObject {
    public static final Gzip$ MODULE$;

    static {
        new Gzip$();
    }

    public boolean isAccepted(HttpRequest request) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip");
    }

    public byte[] compress(byte[] bytes) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        GZIPOutputStream g = new GZIPOutputStream(b);
        g.write(bytes);
        g.finish();
        byte[] gzippedBytes = b.toByteArray();
        g.close();
        b.close();
        return gzippedBytes;
    }

    public byte[] tryCompressBigTextualResponse(HttpRequest request, HttpResponse response) {
        ChannelBuffer channelBuffer = response.getContent();
        byte[] bytes = ChannelBufferToBytes$.MODULE$.apply(channelBuffer);
        if (this.isAccepted(request) && !response.containsHeader("Content-Encoding") && Mime$.MODULE$.isTextual(response.getHeader("Content-Type")) && bytes.length >= Config$.MODULE$.BIG_TEXTUAL_RESPONSE_SIZE_IN_KB() * 1024) {
            byte[] gzippedBytes = this.compress(bytes);
            HttpHeaders.setContentLength((HttpMessage)response, (long)gzippedBytes.length);
            response.setHeader("Content-Encoding", (Object)"gzip");
            response.setContent(ChannelBuffers.wrappedBuffer((byte[])gzippedBytes));
            return gzippedBytes;
        }
        return bytes;
    }

    private Gzip$() {
        MODULE$ = this;
    }
}

