/*
 * Decompiled with CFR 0.152.
 */
package xitrum.handler.up;

import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.slf4j.Logger;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import xitrum.Logger$class;
import xitrum.controller.WebSocket;
import xitrum.handler.up.BadClientSilencer;
import xitrum.handler.up.BadClientSilencer$class;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u0013\t\u0019r+\u001a2T_\u000e\\W\r\u001e#jgB\fGo\u00195fe*\u00111\u0001B\u0001\u0003kBT!!\u0002\u0004\u0002\u000f!\fg\u000e\u001a7fe*\tq!\u0001\u0004ySR\u0014X/\\\u0002\u0001'\u0011\u0001!B\u0006\u000e\u0011\u0005-!R\"\u0001\u0007\u000b\u00055q\u0011aB2iC:tW\r\u001c\u0006\u0003\u001fA\tQA\\3uifT!!\u0005\n\u0002\u000b)\u0014wn]:\u000b\u0003M\t1a\u001c:h\u0013\t)BB\u0001\u000fTS6\u0004H.Z\"iC:tW\r\\+qgR\u0014X-Y7IC:$G.\u001a:\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!!\u0005\"bI\u000ec\u0017.\u001a8u'&dWM\\2feB\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\tY1kY1mC>\u0013'.Z2u\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013A\u00035b]\u0012\u001c\b.Y6feB\u00111eK\u0007\u0002I)\u0011QEJ\u0001\u000bo\u0016\u00147o\\2lKRD(BA\u0014)\u0003\u0011AG\u000f\u001e9\u000b\u0005%R\u0013!B2pI\u0016\u001c'BA\u0003\u000f\u0013\taCEA\rXK\n\u001cvnY6fiN+'O^3s\u0011\u0006tGm\u001d5bW\u0016\u0014\b\u0002C\u0003\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0011\u0005=*\u0004C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0007\u0003)\u0019wN\u001c;s_2dWM]\u0005\u0003iE\u0012\u0011bV3c'>\u001c7.\u001a;\n\u0005Y\u001a$\u0001E,fEN{7m[3u\u0011\u0006tG\r\\3s\u0011\u0015A\u0004\u0001\"\u0001:\u0003\u0019a\u0014N\\5u}Q\u0019!h\u000f\u001f\u0011\u0005]\u0001\u0001\"B\u00118\u0001\u0004\u0011\u0003\"B\u00038\u0001\u0004q\u0003b\u0002 \u0001\u0001\u0004%IaP\u0001\u000f_:\u001cEn\\:fI\u000e\u000bG\u000e\\3e+\u0005\u0001\u0005CA\u000eB\u0013\t\u0011EDA\u0004C_>dW-\u00198\t\u000f\u0011\u0003\u0001\u0019!C\u0005\u000b\u0006\u0011rN\\\"m_N,GmQ1mY\u0016$w\fJ3r)\t1\u0015\n\u0005\u0002\u001c\u000f&\u0011\u0001\n\b\u0002\u0005+:LG\u000fC\u0004K\u0007\u0006\u0005\t\u0019\u0001!\u0002\u0007a$\u0013\u0007\u0003\u0004M\u0001\u0001\u0006K\u0001Q\u0001\u0010_:\u001cEn\\:fI\u000e\u000bG\u000e\\3eA!)a\n\u0001C\u0005\u001f\u0006Y1-\u00197m\u001f:\u001cEn\\:f)\u00051\u0005\"B)\u0001\t\u0003\u0012\u0016aD7fgN\fw-\u001a*fG\u0016Lg/\u001a3\u0015\u0007\u0019\u001b\u0006\fC\u0003U!\u0002\u0007Q+A\u0002dib\u0004\"a\u0003,\n\u0005]c!!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\u00063B\u0003\rAW\u0001\u0002KB\u00111bW\u0005\u000392\u0011A\"T3tg\u0006<W-\u0012<f]R\u0004")
public class WebSocketDispatcher
extends SimpleChannelUpstreamHandler
implements BadClientSilencer {
    private final WebSocketServerHandshaker handshaker;
    private final WebSocket.WebSocketHandler handler;
    private boolean onClosedCalled;
    private final Logger logger;
    public volatile int bitmap$0;

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e2) {
        BadClientSilencer$class.exceptionCaught(this, ctx, e2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        WebSocketDispatcher webSocketDispatcher = this;
        synchronized (webSocketDispatcher) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logger$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    private boolean onClosedCalled() {
        return this.onClosedCalled;
    }

    private void onClosedCalled_$eq(boolean bl) {
        this.onClosedCalled = bl;
    }

    public final void xitrum$handler$up$WebSocketDispatcher$$callOnClose() {
        WebSocketDispatcher webSocketDispatcher = this;
        synchronized (webSocketDispatcher) {
            BoxedUnit boxedUnit;
            if (this.onClosedCalled()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.onClosedCalled_$eq(true);
                this.handler.onClose();
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e2) {
        Object m = e2.getMessage();
        if (m instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)m;
            if (frame instanceof CloseWebSocketFrame) {
                this.handshaker.close(ctx.getChannel(), (CloseWebSocketFrame)frame);
                this.xitrum$handler$up$WebSocketDispatcher$$callOnClose();
                return;
            }
            ctx.getChannel().getCloseFuture().addListener(new ChannelFutureListener(this){
                private final WebSocketDispatcher $outer;

                public void operationComplete(ChannelFuture future) {
                    this.$outer.xitrum$handler$up$WebSocketDispatcher$$callOnClose();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (frame instanceof PingWebSocketFrame) {
                ctx.getChannel().write((Object)new PongWebSocketFrame(frame.getBinaryData()));
                return;
            }
            if (frame instanceof TextWebSocketFrame) {
                String text = ((TextWebSocketFrame)frame).getText();
                this.handler.onMessage(text);
                return;
            }
            this.logger().warn(new StringBuilder().append((Object)"WebSocket frame type not supported: ").append((Object)frame.getClass().getName()).toString());
            ctx.getChannel().close();
            return;
        }
        ctx.sendUpstream((ChannelEvent)e2);
    }

    public WebSocketDispatcher(WebSocketServerHandshaker handshaker, WebSocket.WebSocketHandler handler) {
        this.handshaker = handshaker;
        this.handler = handler;
        Logger$class.$init$(this);
        BadClientSilencer$class.$init$(this);
        this.onClosedCalled = false;
    }
}

