/*
 * Decompiled with CFR 0.152.
 */
package xitrum.etag;

import java.io.File;
import java.security.MessageDigest;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import xitrum.Config$;
import xitrum.Controller;
import xitrum.Logger;
import xitrum.Logger$class;
import xitrum.etag.Etag;
import xitrum.etag.Etag$NotFound$;
import xitrum.scope.request.RequestEnv;
import xitrum.util.Base64$;
import xitrum.util.Gzip$;
import xitrum.util.Loader$;
import xitrum.util.LocalLRUCache;
import xitrum.util.Mime$;

public final class Etag$
implements Logger {
    public static final Etag$ MODULE$;
    private final LocalLRUCache<Tuple2<String, Object>, Etag.Small> smallFileCache;
    private final LocalLRUCache<Tuple2<String, Object>, Etag.Small> gzippedSmallFileCache;
    private final org.slf4j.Logger logger;
    public volatile int bitmap$0;

    static {
        new Etag$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public org.slf4j.Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Etag$ etag$ = this;
        synchronized (etag$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logger$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String forBytes(byte[] bytes) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        md5.update(bytes);
        return Base64$.MODULE$.encode(md5.digest());
    }

    public String forString(String string) {
        return this.forBytes(string.getBytes(Config$.MODULE$.config().request().charset()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Etag.Result forFile(String path, boolean gzipped) {
        long mtime;
        Tuple2 key;
        File file = new File(path);
        if (!file.exists()) return Etag$NotFound$.MODULE$;
        if (file.length() > (long)(Config$.MODULE$.config().response().smallStaticFileSizeInKB() * 1024)) {
            return new Etag.TooBig(file);
        }
        LocalLRUCache<Tuple2<String, Object>, Etag.Small> cache = gzipped ? this.gzippedSmallFileCache : this.smallFileCache;
        Etag.Small value = (Etag.Small)cache.get(key = new Tuple2((Object)path, (Object)BoxesRunTime.boxToLong((long)(mtime = file.lastModified()))));
        if (value != null) return value;
        byte[] bytes = Loader$.MODULE$.bytesFromFile(path);
        if (bytes == null) {
            return Etag$NotFound$.MODULE$;
        }
        String etag = this.forBytes(bytes);
        Etag.Small small = new Etag.Small(bytes, etag, Mime$.MODULE$.get(path), false);
        Etag.Small smaller = gzipped ? this.compressBigTextualFile(small) : small;
        LocalLRUCache<Tuple2<String, Object>, Etag.Small> localLRUCache = cache;
        synchronized (localLRUCache) {
            cache.put((Tuple2<String, Object>)key, smaller);
            return smaller;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Etag.Result forResource(String path, boolean gzipped) {
        Tuple2 key;
        LocalLRUCache<Tuple2<String, Object>, Etag.Small> cache = gzipped ? this.gzippedSmallFileCache : this.smallFileCache;
        Etag.Small value = (Etag.Small)cache.get(key = new Tuple2((Object)new StringBuilder().append((Object)"[resource]").append((Object)path).toString(), (Object)BoxesRunTime.boxToLong((long)0L)));
        if (value != null) return value;
        byte[] bytes = Loader$.MODULE$.bytesFromClasspath(path);
        if (bytes == null) {
            return Etag$NotFound$.MODULE$;
        }
        String etag = this.forBytes(bytes);
        Etag.Small small = new Etag.Small(bytes, etag, Mime$.MODULE$.get(path), false);
        Etag.Small smaller = gzipped ? this.compressBigTextualFile(small) : small;
        LocalLRUCache<Tuple2<String, Object>, Etag.Small> localLRUCache = cache;
        synchronized (localLRUCache) {
            cache.put((Tuple2<String, Object>)key, smaller);
            return smaller;
        }
    }

    public boolean areEtagsIdentical(HttpRequest request, String etag) {
        String string = request.getHeader("If-None-Match");
        String string2 = etag;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean respondIfEtagsIdentical(Controller controller, String etag) {
        boolean bl;
        HttpRequest request = ((RequestEnv)((Object)controller)).request();
        HttpResponse response = ((RequestEnv)((Object)controller)).response();
        if (this.areEtagsIdentical(request, etag)) {
            response.setStatus(HttpResponseStatus.NOT_MODIFIED);
            HttpHeaders.setContentLength((HttpMessage)response, (long)0L);
            response.setContent(ChannelBuffers.EMPTY_BUFFER);
            controller.respond();
            bl = true;
        } else {
            request.setHeader("ETag", (Object)etag);
            bl = false;
        }
        return bl;
    }

    private Etag.Small compressBigTextualFile(Etag.Small small) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = small.mimeo().isDefined() && Mime$.MODULE$.isTextual((String)small.mimeo().get()) ? new Tuple2((Object)Gzip$.MODULE$.compress(small.bytes()), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)small.bytes(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        if (tuple2 != null) {
            Tuple2 tuple23 = new Tuple2(tuple2._1(), tuple2._2());
            byte[] bytes2 = (byte[])tuple23._1();
            boolean gzipped = BoxesRunTime.unboxToBoolean((Object)tuple23._2());
            return new Etag.Small(bytes2, small.etag(), small.mimeo(), gzipped);
        }
        throw new MatchError((Object)tuple2);
    }

    private Etag$() {
        MODULE$ = this;
        Logger$class.$init$(this);
        this.smallFileCache = new LocalLRUCache(Config$.MODULE$.config().response().maxCachedSmallStaticFiles());
        this.gzippedSmallFileCache = new LocalLRUCache(Config$.MODULE$.config().response().maxCachedSmallStaticFiles());
    }
}

