/*
 * Decompiled with CFR 0.152.
 */
package xitrum;

import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEntry;
import com.hazelcast.query.Predicate;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import xitrum.Config$;
import xitrum.Controller;
import xitrum.Logger;
import xitrum.Logger$class;
import xitrum.controller.Action;
import xitrum.routing.ControllerReflection$;
import xitrum.scope.request.RequestEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Cache$
implements Logger {
    public static final Cache$ MODULE$;
    private final IMap<String, Object> cache;
    private final org.slf4j.Logger logger;
    public volatile int bitmap$0;

    static {
        new Cache$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public org.slf4j.Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Cache$ cache$ = this;
        synchronized (cache$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logger$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public IMap<String, Object> cache() {
        return this.cache;
    }

    public void remove(Object key) {
        this.cache().removeAsync((Object)key.toString());
    }

    public void removeAction(Action action) {
        String keyPrefix = this.pageActionPrefix(action);
        this.removePrefix(keyPrefix);
    }

    public String pageActionPrefix(Controller controller) {
        Action action = ((RequestEnv)((Object)controller)).handlerEnv().action();
        return this.pageActionPrefix(action);
    }

    private String pageActionPrefix(Action action) {
        return new StringBuilder().append((Object)"xitrum/page-action/").append((Object)ControllerReflection$.MODULE$.controllerActionName(action)).toString();
    }

    private void removePrefix(Object keyPrefix) {
        String keyPrefixS$1 = keyPrefix.toString();
        Predicate<String, Object> prefixPredicate = new Predicate<String, Object>(keyPrefixS$1){
            private final String keyPrefixS$1;

            public boolean apply(MapEntry<String, Object> mapEntry) {
                return ((String)mapEntry.getKey()).startsWith(this.keyPrefixS$1);
            }
            {
                this.keyPrefixS$1 = string;
            }
        };
        Set keys = this.cache().keySet((Predicate)prefixPredicate);
        for (String key : keys) {
            this.cache().removeAsync((Object)key);
        }
    }

    public void put(Object key, Object value) {
        this.logger().debug(new StringBuilder().append((Object)"put: ").append(key).toString());
        this.cache().putAsync((Object)key.toString(), value);
    }

    public void putSecond(Object key, Object value, int seconds) {
        this.logger().debug(new StringBuilder().append((Object)"put (").append((Object)BoxesRunTime.boxToInteger((int)seconds)).append((Object)"s): ").append(key).toString());
        this.cache().put((Object)key.toString(), value, (long)seconds, TimeUnit.SECONDS);
    }

    public void putMinute(Object key, Object value, int minutes) {
        this.putSecond(key, value, minutes * 60);
    }

    public void putHour(Object key, Object value, int hours) {
        this.putMinute(key, value, hours * 60);
    }

    public void putDay(Object key, Object value, int days) {
        this.putHour(key, value, days * 24);
    }

    public void putIfAbsent(Object key, Object value) {
        this.logger().debug(new StringBuilder().append((Object)"putIfAbsent: ").append(key).toString());
        this.cache().putIfAbsent((Object)key.toString(), value);
    }

    public void putIfAbsentSecond(Object key, Object value, int seconds) {
        this.logger().debug(new StringBuilder().append((Object)"putIfAbsent (").append((Object)BoxesRunTime.boxToInteger((int)seconds)).append((Object)"s): ").append(key).toString());
        this.cache().putIfAbsent((Object)key.toString(), value, (long)seconds, TimeUnit.SECONDS);
    }

    public void putIfAbsentMinute(Object key, Object value, int minutes) {
        this.putIfAbsentSecond(key, value, minutes * 60);
    }

    public void putIfAbsentHour(Object key, Object value, int hours) {
        this.putIfAbsentMinute(key, value, hours * 60);
    }

    public void putIfAbsentDay(Object key, Object value, int days) {
        this.putIfAbsentHour(key, value, days * 24);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Option<T> getAs(Object key) {
        void var2_2;
        if (!Config$.MODULE$.isProductionMode()) return None$.MODULE$;
        Option exceptionResult1 = null;
        try {
            exceptionResult1 = Option$.MODULE$.apply(this.cache().get(key)).map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final T apply(Object object) {
                    return (T)object;
                }
            });
            return var2_2;
        }
        catch (Throwable throwable) {
            this.logger().warn("Cache data restoring failed, will now remove it, key: {}", key);
            this.cache().remove(key);
            exceptionResult1 = None$.MODULE$;
        }
        return var2_2;
    }

    public <T> T tryCacheSecond(Object key$1, int secs$1, Function0<T> f$1) {
        return (T)this.getAs(key$1).getOrElse((Function0)new Serializable(key$1, secs$1, f$1){
            public static final long serialVersionUID;
            private final Object key$1;
            private final int secs$1;
            private final Function0 f$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             */
            public final T apply() {
                void var1_1;
                Object value = this.f$1.apply();
                Cache$.MODULE$.putIfAbsentSecond(this.key$1, value, this.secs$1);
                return var1_1;
            }
            {
                this.key$1 = object;
                this.secs$1 = n;
                this.f$1 = function0;
            }
        });
    }

    public <T> T tryCacheMinute(String key, int minutes, Function0<T> f) {
        return this.tryCacheSecond(key, minutes * 60, f);
    }

    public <T> T tryCacheHour(String key, int hours, Function0<T> f) {
        return this.tryCacheMinute(key, hours * 60, f);
    }

    public <T> T tryCacheDay(String key, int days, Function0<T> f) {
        return this.tryCacheHour(key, days * 24, f);
    }

    private Cache$() {
        MODULE$ = this;
        Logger$class.$init$(this);
        this.cache = Config$.MODULE$.hazelcastInstance().getMap("xitrum/cache");
    }
}

