/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.databaseaccess.QueryStringCall;
import oracle.toplink.essentials.internal.expressions.ParameterExpression;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class SQLCall
extends DatabaseCall
implements QueryStringCall {
    protected boolean hasCustomSQLArguments = false;

    public SQLCall() {
    }

    public SQLCall(String sqlString) {
        this();
        this.setSQLString(sqlString);
    }

    protected void afterTranslateCustomQuery(Vector updatedParameters, Vector updatedParameterTypes) {
        for (int i = 0; i < this.getParameters().size(); ++i) {
            Integer parameterType = (Integer)this.getParameterTypes().elementAt(i);
            Object parameter = this.getParameters().elementAt(i);
            if (parameterType == MODIFY || parameterType == OUT || parameterType == OUT_CURSOR || parameterType == IN && parameter instanceof DatabaseField) {
                DatabaseField field = (DatabaseField)parameter;
                this.afterTranslateCustomQueryUpdateParameter(field, i, parameterType, updatedParameters, updatedParameterTypes);
                continue;
            }
            if (parameterType != INOUT) continue;
            DatabaseField outField = (DatabaseField)((Object[])parameter)[1];
            this.afterTranslateCustomQueryUpdateParameter(outField, i, parameterType, updatedParameters, updatedParameterTypes);
            if (!(((Object[])parameter)[0] instanceof DatabaseField) || ((Object[])parameter)[0] == ((Object[])parameter)[1]) continue;
            DatabaseField inField = (DatabaseField)((Object[])parameter)[0];
            this.afterTranslateCustomQueryUpdateParameter(inField, i, parameterType, updatedParameters, updatedParameterTypes);
        }
    }

    protected void afterTranslateCustomQueryUpdateParameter(DatabaseField field, int index, Integer parameterType, Vector updatedParameters, Vector updatedParameterTypes) {
        for (int j = 0; j < updatedParameters.size(); ++j) {
            DatabaseField updateField = (DatabaseField)updatedParameters.elementAt(j);
            if (!field.equals(updateField)) continue;
            Integer updateParameterType = (Integer)updatedParameterTypes.elementAt(j);
            if (updateParameterType == null) {
                field.setType(updateField.getType());
                break;
            }
            if (updateParameterType != OUT_CURSOR) break;
            if (parameterType == OUT) {
                this.getParameterTypes().setElementAt(OUT_CURSOR, index);
                break;
            }
            throw ValidationException.cannotSetCursorForParameterTypeOtherThanOut(field.getName(), this.toString());
        }
    }

    public boolean hasCustomSQLArguments() {
        return this.hasCustomSQLArguments;
    }

    public boolean isSQLCall() {
        return true;
    }

    public boolean isQueryStringCall() {
        return true;
    }

    protected void prepareInternal(AbstractSession session) {
        if (this.hasCustomSQLArguments()) {
            Vector updatedParameters = null;
            Vector updatedParameterTypes = null;
            if (this.getParameters().size() > 0) {
                updatedParameters = this.getParameters();
                this.setParameters(NonSynchronizedVector.newInstance());
                updatedParameterTypes = this.getParameterTypes();
                this.setParameterTypes(NonSynchronizedVector.newInstance());
            }
            this.translateCustomQuery();
            if (updatedParameters != null) {
                this.afterTranslateCustomQuery(updatedParameters, updatedParameterTypes);
            }
        }
        super.prepareInternal(session);
    }

    public void setHasCustomSQLArguments(boolean hasCustomSQLArguments) {
        this.hasCustomSQLArguments = hasCustomSQLArguments;
    }

    public void setCustomSQLArgumentType(String customParameterName, Class type) {
        DatabaseField field = new DatabaseField(customParameterName);
        field.setType(type);
        this.getParameters().add(field);
        this.getParameterTypes().add(null);
    }

    public void setSQLString(String sqlString) {
        this.setSQLStringInternal(sqlString);
    }

    public void appendTranslationParameter(Writer writer, ParameterExpression expression, DatabasePlatform platform) throws IOException {
        try {
            platform.writeParameterMarker(writer, expression);
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(expression);
        this.getParameterTypes().addElement(TRANSLATION);
    }

    public void useCustomSQLCursorOutputAsResultSet(String customParameterName) {
        DatabaseField field = new DatabaseField(customParameterName);
        this.getParameters().add(field);
        this.getParameterTypes().add(OUT_CURSOR);
        this.setIsCursorOutputProcedure(true);
    }
}

