/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.NonRelationshipAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.converters.Converter;
import oracle.toplink.essentials.mappings.converters.EnumTypeConverter;
import oracle.toplink.essentials.mappings.converters.SerializedObjectConverter;
import oracle.toplink.essentials.mappings.converters.TypeConversionConverter;
import oracle.toplink.essentials.mappings.foundation.AbstractDirectMapping;

public abstract class DirectAccessor
extends NonRelationshipAccessor {
    public DirectAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    protected abstract MetadataColumn getColumn(String var1);

    public DatabaseField getDatabaseField(String loggingCtx) {
        MetadataColumn column = this.m_descriptor.hasAttributeOverrideFor(this.getAttributeName()) ? this.m_descriptor.getAttributeOverrideFor(this.getAttributeName()) : this.getColumn(loggingCtx);
        DatabaseField field = column.getDatabaseField();
        String defaultName = column.getUpperCaseAttributeName();
        field.setName(this.getName(field.getName(), defaultName, loggingCtx));
        return field;
    }

    public String getEnumeratedType() {
        Enumerated enumerated = (Enumerated)this.getAnnotation(Enumerated.class);
        if (enumerated == null) {
            return EnumType.ORDINAL.name();
        }
        return enumerated.value().name();
    }

    public String getTemporalType() {
        Temporal temporal = (Temporal)this.getAnnotation(Temporal.class);
        return temporal.value().name();
    }

    public boolean hasEnumerated() {
        return this.isAnnotationPresent(Enumerated.class);
    }

    public boolean hasLob() {
        return this.isAnnotationPresent(Lob.class);
    }

    public boolean hasTemporal() {
        return this.isAnnotationPresent(Temporal.class);
    }

    public boolean isEnumerated() {
        return this.hasEnumerated() || MetadataHelper.isValidEnumeratedType(this.getReferenceClass());
    }

    public boolean isLob() {
        return this.hasLob();
    }

    public boolean isSerialized() {
        return MetadataHelper.isValidSerializedType(this.getReferenceClass());
    }

    public boolean isTemporal() {
        return this.hasTemporal() || MetadataHelper.isValidTemporalType(this.getReferenceClass());
    }

    protected void processEnumerated(DatabaseMapping mapping) {
        if (this.hasEnumerated() && !MetadataHelper.isValidEnumeratedType(this.getReferenceClass())) {
            this.m_validator.throwInvalidTypeForEnumeratedAttribute(this.getJavaClass(), mapping.getAttributeName(), this.getReferenceClass());
        }
        this.setConverter(mapping, new EnumTypeConverter(mapping, this.getReferenceClass(), this.getEnumeratedType().equals(EnumType.ORDINAL.name())));
    }

    protected void processJPAConverters(DatabaseMapping mapping) {
        if (this.isEnumerated()) {
            this.processEnumerated(mapping);
        } else if (this.isLob()) {
            this.processLob(mapping);
        } else if (this.isTemporal()) {
            this.processTemporal(mapping);
            ((AbstractDirectMapping)mapping).setIsMutable(true);
        } else if (this.isSerialized()) {
            this.processSerialized(mapping);
        } else if (MetadataHelper.isValidDateType(this.getReferenceClass())) {
            ((AbstractDirectMapping)mapping).setIsMutable(true);
        }
    }

    protected void processLob(DatabaseMapping mapping) {
        if (MetadataHelper.isValidClobType(this.getReferenceClass())) {
            this.setFieldClassification(mapping, Clob.class);
            this.setConverter(mapping, new TypeConversionConverter(mapping));
        } else if (MetadataHelper.isValidBlobType(this.getReferenceClass())) {
            this.setFieldClassification(mapping, Blob.class);
            this.setConverter(mapping, new TypeConversionConverter(mapping));
        } else if (Helper.classImplementsInterface(this.getReferenceClass(), Serializable.class)) {
            this.setFieldClassification(mapping, Blob.class);
            this.setConverter(mapping, new SerializedObjectConverter(mapping));
        } else {
            this.m_validator.throwInvalidTypeForLOBAttribute(this.getJavaClass(), mapping.getAttributeName(), this.getReferenceClass());
        }
    }

    protected void processMappingConverter(DatabaseMapping mapping) {
        this.processJPAConverters(mapping);
    }

    protected void processSerialized(DatabaseMapping mapping) {
        if (Helper.classImplementsInterface(this.getReferenceClass(), Serializable.class)) {
            SerializedObjectConverter converter = new SerializedObjectConverter(mapping);
            this.setConverter(mapping, converter);
        } else {
            this.m_validator.throwInvalidTypeForSerializedAttribute(this.getJavaClass(), mapping.getAttributeName(), this.getReferenceClass());
        }
    }

    protected void processTemporal(DatabaseMapping mapping) {
        if (this.hasTemporal()) {
            if (MetadataHelper.isValidTemporalType(this.getReferenceClass())) {
                this.setFieldClassification(mapping, MetadataHelper.getFieldClassification(this.getTemporalType()));
                this.setConverter(mapping, new TypeConversionConverter(mapping));
            } else {
                this.m_validator.throwInvalidTypeForTemporalAttribute(this.getJavaClass(), this.getAttributeName(), this.getReferenceClass());
            }
        } else {
            this.m_validator.throwNoTemporalTypeSpecified(this.getJavaClass(), this.getAttributeName());
        }
    }

    public abstract void setConverter(DatabaseMapping var1, Converter var2);

    public abstract void setFieldClassification(DatabaseMapping var1, Class var2);
}

