/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.ejb.cmp3.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import oracle.toplink.essentials.ejb.cmp3.persistence.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLArchive
implements Archive {
    private URL url;

    public URLArchive(URL url) {
        this.url = url;
    }

    @Override
    public Iterator<String> getEntries() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public InputStream getEntry(String entryPath) throws IOException {
        URL subEntry = new URL(this.url, entryPath);
        InputStream is = null;
        try {
            is = subEntry.openStream();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return is;
    }

    @Override
    public URL getEntryAsURL(String entryPath) throws IOException {
        URL subEntry = new URL(this.url, entryPath);
        try {
            InputStream is = subEntry.openStream();
            is.close();
        }
        catch (IOException ioe) {
            return null;
        }
        return subEntry;
    }

    @Override
    public URL getRootURL() {
        return this.url;
    }
}

