/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.security.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import top.tangyh.basic.base.R;
import top.tangyh.basic.security.feign.UserQuery;
import top.tangyh.basic.security.feign.UserResolverService;
import top.tangyh.basic.security.model.SysUser;
import top.tangyh.basic.utils.SpringUtils;

@Configuration
@ConditionalOnProperty(prefix="lamp.security", name={"type"}, havingValue="FEIGN", matchIfMissing=true)
@EnableFeignClients(basePackageClasses={UserResolveApi.class})
public class UserResolveFeignConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={UserResolverService.class})
    public UserResolverService getUserResolverService(UserResolveApi userResolveApi) {
        return new UserResolverServiceFeignImpl(userResolveApi);
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringUtils.class})
    public SpringUtils getSpringUtils(ApplicationContext applicationContext) {
        SpringUtils instance = SpringUtils.getInstance();
        SpringUtils.setApplicationContext((ApplicationContext)applicationContext);
        return instance;
    }

    @Component
    public static class UserResolveApiFallback
    implements UserResolveApi {
        @Override
        public R<SysUser> getById(Long id, UserQuery userQuery) {
            return R.timeout();
        }
    }

    public static class UserResolverServiceFeignImpl
    implements UserResolverService {
        private final UserResolveApi userResolveApi;

        public UserResolverServiceFeignImpl(UserResolveApi userResolveApi) {
            this.userResolveApi = userResolveApi;
        }

        @Override
        public R<SysUser> getById(Long id, UserQuery userQuery) {
            return this.userResolveApi.getById(id, userQuery);
        }
    }

    @FeignClient(name="${lamp.feign.oauth-server:lamp-oauth-server}", path="/user", fallback=UserResolveApiFallback.class)
    public static interface UserResolveApi {
        @PostMapping(value={"/anno/id/{id}"})
        public R<SysUser> getById(@PathVariable(value="id") Long var1, @RequestBody UserQuery var2);
    }
}

