/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.security.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import top.tangyh.basic.security.aspect.UriSecurityPreAuthAspect;
import top.tangyh.basic.security.aspect.VerifyAuthFunction;
import top.tangyh.basic.security.feign.UserResolverService;
import top.tangyh.basic.security.properties.SecurityProperties;

@Order
@EnableConfigurationProperties(value={SecurityProperties.class})
public class SecurityConfiguration {
    private final SecurityProperties securityProperties;

    @Bean
    @ConditionalOnProperty(prefix="lamp.security", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public UriSecurityPreAuthAspect uriSecurityPreAuthAspect(VerifyAuthFunction verifyAuthFunction) {
        return new UriSecurityPreAuthAspect(verifyAuthFunction);
    }

    @Bean(value={"fun"})
    @ConditionalOnMissingBean(value={VerifyAuthFunction.class})
    public VerifyAuthFunction getVerifyAuthFunction(UserResolverService userResolverService) {
        return new VerifyAuthFunction(userResolverService, this.securityProperties);
    }

    public SecurityConfiguration(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }
}

