/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.security.aspect;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.core.env.Environment;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.tangyh.basic.annotation.security.PreAuth;
import top.tangyh.basic.exception.ForbiddenException;
import top.tangyh.basic.exception.code.BaseExceptionCode;
import top.tangyh.basic.exception.code.ExceptionCode;
import top.tangyh.basic.security.aspect.VerifyAuthFunction;

@Aspect
public class UriSecurityPreAuthAspect
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(UriSecurityPreAuthAspect.class);
    private static final ExpressionParser SP_EL_PARSER = new SpelExpressionParser();
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final VerifyAuthFunction verifyAuthFunction;
    private ApplicationContext ac;

    public UriSecurityPreAuthAspect(VerifyAuthFunction verifyAuthFunction) {
        this.verifyAuthFunction = verifyAuthFunction;
    }

    @Around(value="execution(public * top.tangyh.basic.base.controller.*.*(..)) || @annotation(top.tangyh.basic.annotation.security.PreAuth) || @within(top.tangyh.basic.annotation.security.PreAuth)")
    public Object preAuth(ProceedingJoinPoint point) throws Throwable {
        this.handleAuth(point);
        return point.proceed();
    }

    private void handleAuth(ProceedingJoinPoint point) {
        Environment env = this.ac.getEnvironment();
        Boolean property = (Boolean)env.getProperty("lamp.security.enabled", Boolean.class, (Object)false);
        if (!property.booleanValue()) {
            log.debug("\u5168\u5c40\u6821\u9a8c\u6743\u9650\u5df2\u7ecf\u5173\u95ed");
            return;
        }
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        PreAuth preAuth = null;
        if (point.getSignature() instanceof MethodSignature && (method = ((MethodSignature)point.getSignature()).getMethod()) != null) {
            preAuth = method.getAnnotation(PreAuth.class);
        }
        String methodName = method != null ? method.getName() : "";
        PreAuth targetClass = point.getTarget().getClass().getAnnotation(PreAuth.class);
        if (preAuth == null && targetClass == null) {
            log.debug("\u6267\u884c\u65b9\u6cd5[{}]\u65e0\u9700\u6821\u9a8c\u6743\u9650", (Object)methodName);
            return;
        }
        if (preAuth != null && !preAuth.enabled()) {
            log.debug("\u6267\u884c\u65b9\u6cd5[{}]\u65e0\u9700\u6821\u9a8c\u6743\u9650", (Object)methodName);
            return;
        }
        if (targetClass != null && !targetClass.enabled()) {
            log.debug("\u6267\u884c\u65b9\u6cd5[{}]\u65e0\u9700\u6821\u9a8c\u6743\u9650", (Object)methodName);
            return;
        }
        if (this.isFeign(methodName)) {
            return;
        }
        String condition = this.getCondition(preAuth, targetClass);
        if (StrUtil.isBlank((CharSequence)condition)) {
            return;
        }
        Boolean hasPermit = this.invokePermit(point, method, condition);
        if (!hasPermit.booleanValue()) {
            throw ForbiddenException.wrap((BaseExceptionCode)ExceptionCode.FORBIDDEN.build("\u6267\u884c\u65b9\u6cd5[%s]\u9700\u8981[%s]\u6743\u9650", new Object[]{methodName, condition}));
        }
    }

    private boolean isFeign(String methodName) {
        HttpServletRequest request;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && (request = ((ServletRequestAttributes)requestAttributes).getRequest()) != null && "true".equals(request.getHeader("x-feign"))) {
            log.debug("\u5185\u90e8\u8c03\u7528\u65b9\u6cd5[{}]\u65e0\u9700\u6821\u9a8c\u6743\u9650", (Object)methodName);
            return true;
        }
        return false;
    }

    @Nullable
    private Boolean invokePermit(ProceedingJoinPoint point, Method method, String condition) {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)this.verifyAuthFunction);
        Expression expression = SP_EL_PARSER.parseExpression(condition);
        Object[] args = point.getArgs();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.ac));
        for (int i = 0; i < args.length; ++i) {
            SynthesizingMethodParameter mp = new SynthesizingMethodParameter(method, i);
            mp.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
            context.setVariable(mp.getParameterName(), args[i]);
        }
        return (Boolean)expression.getValue((EvaluationContext)context, Boolean.class);
    }

    @Nullable
    private String getCondition(PreAuth preAuth, PreAuth targetClass) {
        String condition;
        String string = condition = preAuth == null ? targetClass.value() : preAuth.value();
        if (condition.contains("{}")) {
            if (targetClass != null && StrUtil.isNotBlank((CharSequence)targetClass.replace())) {
                condition = StrUtil.format((CharSequence)condition, (Object[])new Object[]{targetClass.replace()});
            } else {
                return null;
            }
        }
        return condition;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.ac = applicationContext;
    }
}

