/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cache.model;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.time.Duration;
import java.util.ArrayList;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import top.tangyh.basic.cache.model.CacheHashKey;
import top.tangyh.basic.cache.model.CacheKey;
import top.tangyh.basic.context.ContextUtil;
import top.tangyh.basic.utils.ArgumentAssert;

@FunctionalInterface
public interface CacheKeyBuilder {
    @NonNull
    default public String getTenant() {
        return ContextUtil.getTenant();
    }

    @NonNull
    public String getPrefix();

    @Nullable
    default public Duration getExpire() {
        return null;
    }

    default public String getPattern() {
        return StrUtil.format((CharSequence)"*:{}:*", (Object[])new Object[]{this.getPrefix()});
    }

    default public String getPattern(String tenant, Object ... suffix) {
        String prefix = this.getPrefix();
        ArgumentAssert.notEmpty(prefix, "\u7f13\u5b58\u524d\u7f00\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        ArrayList<String> regionList = new ArrayList<String>();
        String string = tenant = StrUtil.isEmpty((CharSequence)tenant) ? "*" : tenant;
        if (StrUtil.isNotEmpty((CharSequence)tenant)) {
            regionList.add(tenant);
        }
        regionList.add(prefix);
        for (Object s : suffix) {
            regionList.add(ObjectUtil.isNotEmpty((Object)s) ? String.valueOf(s) : "*");
        }
        return CollUtil.join(regionList, (CharSequence)":");
    }

    default public CacheKey key(Object ... suffix) {
        String field = suffix.length > 0 ? Convert.toStr((Object)suffix[0], (String)"") : "";
        return this.hashFieldKey(field, suffix);
    }

    default public CacheHashKey hashFieldKey(@NonNull Object field, Object ... suffix) {
        String key = this.getKey(suffix);
        ArgumentAssert.notEmpty(key, "key \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        ArgumentAssert.notNull(field, "field \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        return new CacheHashKey(key, field, this.getExpire());
    }

    default public CacheHashKey hashKey(Object ... suffix) {
        String key = this.getKey(suffix);
        ArgumentAssert.notEmpty(key, "key \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        return new CacheHashKey(key, null, this.getExpire());
    }

    default public String getKey(Object ... suffix) {
        ArrayList<String> regionList = new ArrayList<String>();
        String tenant = this.getTenant();
        if (StrUtil.isNotEmpty((CharSequence)tenant)) {
            regionList.add(tenant);
        }
        String prefix = this.getPrefix();
        ArgumentAssert.notEmpty(prefix, "\u7f13\u5b58\u524d\u7f00\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        regionList.add(prefix);
        for (Object s : suffix) {
            if (!ObjectUtil.isNotEmpty((Object)s)) continue;
            regionList.add(String.valueOf(s));
        }
        return CollUtil.join(regionList, (CharSequence)":");
    }
}

