/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.util.List;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.impl.PropertySerializerMap;
import tools.jackson.databind.ser.std.AsArraySerializerBase;
import tools.jackson.databind.ser.std.StdContainerSerializer;

@JacksonStdImpl
public final class IndexedListSerializer
extends AsArraySerializerBase<Object> {
    public IndexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, ValueSerializer<Object> valueSerializer) {
        super(List.class, elemType, staticTyping, vts, valueSerializer);
    }

    public IndexedListSerializer(IndexedListSerializer src, TypeSerializer vts, ValueSerializer<?> valueSerializer, Boolean unwrapSingle, BeanProperty property) {
        super(src, vts, valueSerializer, unwrapSingle, property);
    }

    @Override
    protected StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new IndexedListSerializer(this, vts, this._elementSerializer, this._unwrapSingle, this._property);
    }

    public IndexedListSerializer withResolved(BeanProperty property, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle) {
        return new IndexedListSerializer(this, vts, elementSerializer, unwrapSingle, property);
    }

    @Override
    public boolean isEmpty(SerializationContext prov, Object value) {
        return ((List)value).isEmpty();
    }

    @Override
    public boolean hasSingleElement(Object value) {
        return ((List)value).size() == 1;
    }

    @Override
    public final void serialize(Object value0, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        List value = (List)value0;
        int len = value.size();
        if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value, gen, provider);
            return;
        }
        gen.writeStartArray((Object)value, len);
        this.serializeContents(value, gen, provider);
        gen.writeEndArray();
    }

    @Override
    public void serializeContents(Object value0, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int i;
        List value = (List)value0;
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(value, g, ctxt, this._elementSerializer);
            return;
        }
        if (this._valueTypeSerializer != null) {
            this.serializeTypedContents(value, g, ctxt);
            return;
        }
        int len = value.size();
        if (len == 0) {
            return;
        }
        try {
            for (i = 0; i < len; ++i) {
                Object elem = value.get(i);
                if (elem == null) {
                    ctxt.defaultSerializeNullValue(g);
                    continue;
                }
                Class<?> cc = elem.getClass();
                ValueSerializer<Object> serializer = this._dynamicValueSerializers.serializerFor(cc);
                if (serializer == null) {
                    serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._elementType, cc)) : this._findAndAddDynamic(ctxt, cc);
                }
                serializer.serialize(elem, g, ctxt);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, (Object)value, i);
        }
    }

    public void serializeContentsUsing(List<?> value, JsonGenerator jgen, SerializationContext provider, ValueSerializer<Object> ser) throws JacksonException {
        int len = value.size();
        if (len == 0) {
            return;
        }
        TypeSerializer typeSer = this._valueTypeSerializer;
        for (int i = 0; i < len; ++i) {
            Object elem = value.get(i);
            try {
                if (elem == null) {
                    provider.defaultSerializeNullValue(jgen);
                    continue;
                }
                if (typeSer == null) {
                    ser.serialize(elem, jgen, provider);
                    continue;
                }
                ser.serializeWithType(elem, jgen, provider, typeSer);
                continue;
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value, i);
            }
        }
    }

    public void serializeTypedContents(List<?> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        int i;
        int len = value.size();
        if (len == 0) {
            return;
        }
        try {
            TypeSerializer typeSer = this._valueTypeSerializer;
            PropertySerializerMap serializers = this._dynamicValueSerializers;
            for (i = 0; i < len; ++i) {
                Object elem = value.get(i);
                if (elem == null) {
                    ctxt.defaultSerializeNullValue(g);
                    continue;
                }
                Class<?> cc = elem.getClass();
                ValueSerializer<Object> serializer = serializers.serializerFor(cc);
                if (serializer == null) {
                    serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._elementType, cc)) : this._findAndAddDynamic(ctxt, cc);
                    serializers = this._dynamicValueSerializers;
                }
                serializer.serializeWithType(elem, g, ctxt, typeSer);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, value, i);
        }
    }
}

