/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.introspect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Objects;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.introspect.AnnotatedWithParams;
import tools.jackson.databind.introspect.AnnotationMap;
import tools.jackson.databind.introspect.TypeResolutionContext;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.internal.UnreflectHandleSupplier;

public final class AnnotatedConstructor
extends AnnotatedWithParams {
    protected final Constructor<?> _constructor;
    private final InvokerHolder _invokerNullary = new InvokerHolder(MethodType.methodType(Object.class));
    private final InvokerHolder _invokerUnary = new InvokerHolder(MethodType.methodType(Object.class, Object.class));
    private final InvokerHolder _invokerFixedArity = new InvokerHolder(null);

    public AnnotatedConstructor(TypeResolutionContext ctxt, Constructor<?> constructor, AnnotationMap classAnn, AnnotationMap[] paramAnn) {
        super(ctxt, classAnn, paramAnn);
        this._constructor = Objects.requireNonNull(constructor);
    }

    @Override
    public AnnotatedConstructor withAnnotations(AnnotationMap ann) {
        return new AnnotatedConstructor(this._typeContext, this._constructor, ann, this._paramAnnotations);
    }

    @Override
    public Constructor<?> getAnnotated() {
        return this._constructor;
    }

    @Override
    public int getModifiers() {
        return this._constructor.getModifiers();
    }

    @Override
    public String getName() {
        return this._constructor.getName();
    }

    @Override
    public JavaType getType() {
        return this._typeContext.resolveType(this.getRawType());
    }

    @Override
    public Class<?> getRawType() {
        return this._constructor.getDeclaringClass();
    }

    @Override
    public int getParameterCount() {
        return this._constructor.getParameterCount();
    }

    @Override
    public Class<?> getRawParameterType(int index) {
        Class<?>[] types = this._constructor.getParameterTypes();
        return index >= types.length ? null : types[index];
    }

    @Override
    public JavaType getParameterType(int index) {
        Type[] types = this._constructor.getGenericParameterTypes();
        if (index >= types.length) {
            return null;
        }
        return this._typeContext.resolveType(types[index]);
    }

    @Override
    public Parameter[] getNativeParameters() {
        return this._constructor.getParameters();
    }

    @Override
    public final Object call() throws Exception {
        try {
            return this._invokerNullary.get().invokeExact();
        }
        catch (Throwable e) {
            throw ClassUtil.sneakyThrow(e);
        }
    }

    @Override
    public final Object call(Object[] args) throws Exception {
        try {
            return this._invokerFixedArity.get().invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw ClassUtil.sneakyThrow(e);
        }
    }

    @Override
    public final Object call1(Object arg) throws Exception {
        try {
            return this._invokerUnary.get().invokeExact(arg);
        }
        catch (Throwable e) {
            throw ClassUtil.sneakyThrow(e);
        }
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._constructor.getDeclaringClass();
    }

    @Override
    public Member getMember() {
        return this._constructor;
    }

    @Override
    public void setValue(Object pojo, Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot call setValue() on constructor of " + this.getDeclaringClass().getName());
    }

    @Override
    public Object getValue(Object pojo) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot call getValue() on constructor of " + this.getDeclaringClass().getName());
    }

    @Override
    public String toString() {
        int argCount = this._constructor.getParameterCount();
        return String.format("[constructor for %s (%d arg%s), annotations: %s", ClassUtil.nameOf(this._constructor.getDeclaringClass()), argCount, argCount == 1 ? "" : "s", this._annotations);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this._constructor);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!ClassUtil.hasClass(o, this.getClass())) {
            return false;
        }
        AnnotatedConstructor other = (AnnotatedConstructor)o;
        return Objects.equals(this._constructor, other._constructor);
    }

    class InvokerHolder
    extends UnreflectHandleSupplier {
        private static final long serialVersionUID = 1L;

        InvokerHolder(MethodType asType) {
            super(asType);
        }

        @Override
        protected MethodHandle unreflect() throws IllegalAccessException {
            return MethodHandles.lookup().unreflectConstructor(AnnotatedConstructor.this._constructor);
        }
    }
}

