/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.GeneratorSettings;
import tools.jackson.databind.cfg.HandlerInstantiator;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.TreeBuildingGenerator;
import tools.jackson.databind.ser.SerializerCache;
import tools.jackson.databind.ser.SerializerFactory;
import tools.jackson.databind.ser.WritableObjectId;
import tools.jackson.databind.util.ClassUtil;

public class SerializationContextExt
extends SerializationContext {
    protected transient Map<Object, WritableObjectId> _seenObjectIds;
    protected transient ArrayList<ObjectIdGenerator<?>> _objectIdGenerators;

    protected SerializationContextExt(TokenStreamFactory streamFactory, SerializationConfig config, GeneratorSettings genSettings, SerializerFactory f, SerializerCache cache) {
        super(streamFactory, config, genSettings, f, cache);
    }

    @Override
    public ValueSerializer<Object> serializerInstance(Annotated annotated, Object serDef) {
        ValueSerializer ser;
        if (serDef == null) {
            return null;
        }
        if (serDef instanceof ValueSerializer) {
            ser = (ValueSerializer)serDef;
        } else {
            HandlerInstantiator hi;
            Class serClass;
            if (!(serDef instanceof Class)) {
                this.reportBadDefinition(annotated.getType(), "AnnotationIntrospector returned serializer definition of type " + serDef.getClass().getName() + "; expected type `ValueSerializer` or `Class<ValueSerializer>` instead");
            }
            if ((serClass = (Class)serDef) == ValueSerializer.None.class || ClassUtil.isBogusClass(serClass)) {
                return null;
            }
            if (!ValueSerializer.class.isAssignableFrom(serClass)) {
                this.reportBadDefinition(annotated.getType(), "AnnotationIntrospector returned Class `" + serClass.getName() + "`; expected `Class<ValueSerializer>`");
            }
            ValueSerializer valueSerializer = ser = (hi = this._config.getHandlerInstantiator()) == null ? null : hi.serializerInstance(this._config, annotated, serClass);
            if (ser == null) {
                ser = (ValueSerializer)ClassUtil.createInstance(serClass, this._config.canOverrideAccessModifiers());
            }
        }
        return this._handleResolvable(ser);
    }

    @Override
    public Object includeFilterInstance(BeanPropertyDefinition forProperty, Class<?> filterClass) {
        Object filter;
        if (filterClass == null) {
            return null;
        }
        HandlerInstantiator hi = this._config.getHandlerInstantiator();
        Object object = filter = hi == null ? null : hi.includeFilterInstance(this._config, forProperty, filterClass);
        if (filter == null) {
            filter = ClassUtil.createInstance(filterClass, this._config.canOverrideAccessModifiers());
        }
        return filter;
    }

    @Override
    public boolean includeFilterSuppressNulls(Object filter) {
        if (filter == null) {
            return true;
        }
        try {
            return filter.equals(null);
        }
        catch (Exception e) {
            String msg = String.format("Problem determining whether filter of type '%s' should filter out `null` values: (%s) %s", filter.getClass().getName(), e.getClass().getName(), ClassUtil.exceptionMessage(e));
            this.reportBadDefinition(filter.getClass(), msg, (Throwable)e);
            return false;
        }
    }

    @Override
    public <T extends JsonNode> T valueToTree(Object fromValue) throws JacksonException {
        JsonNodeFactory nodeF = this._config.getNodeFactory();
        if (fromValue == null) {
            return (T)nodeF.nullNode();
        }
        try (TreeBuildingGenerator gen = TreeBuildingGenerator.forSerialization(this, nodeF);){
            Class<?> rawType = fromValue.getClass();
            ValueSerializer<Object> ser = this.findTypedValueSerializer(rawType, true);
            PropertyName rootName = this._config.getFullRootName();
            if (rootName == null) {
                if (this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                    this._serialize(gen, fromValue, ser, this.findRootName(rawType));
                } else {
                    this._serialize(gen, fromValue, ser);
                }
            } else if (!rootName.isEmpty()) {
                this._serialize(gen, fromValue, ser, rootName);
            } else {
                this._serialize(gen, fromValue, ser);
            }
            JsonNode jsonNode = gen.treeBuilt();
            return (T)jsonNode;
        }
    }

    @Override
    public WritableObjectId findObjectId(Object forPojo, ObjectIdGenerator<?> generatorType) {
        if (this._seenObjectIds == null) {
            this._seenObjectIds = this._createObjectIdMap();
        } else {
            WritableObjectId oid = this._seenObjectIds.get(forPojo);
            if (oid != null) {
                return oid;
            }
        }
        ObjectIdGenerator<?> generator = null;
        if (this._objectIdGenerators == null) {
            this._objectIdGenerators = new ArrayList(8);
        } else {
            int len = this._objectIdGenerators.size();
            for (int i = 0; i < len; ++i) {
                ObjectIdGenerator<?> gen = this._objectIdGenerators.get(i);
                if (!gen.canUseFor(generatorType)) continue;
                generator = gen;
                break;
            }
        }
        if (generator == null) {
            generator = generatorType.newForSerialization((Object)this);
            this._objectIdGenerators.add(generator);
        }
        WritableObjectId oid = new WritableObjectId(generator);
        this._seenObjectIds.put(forPojo, oid);
        return oid;
    }

    protected Map<Object, WritableObjectId> _createObjectIdMap() {
        if (this.isEnabled(SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID)) {
            return new HashMap<Object, WritableObjectId>();
        }
        return new IdentityHashMap<Object, WritableObjectId>();
    }

    @Override
    public JsonGenerator getGenerator() {
        return this._generator;
    }

    public void serializeValue(JsonGenerator gen, Object value) throws JacksonException {
        this._assignGenerator(gen);
        if (value == null) {
            this._serializeNull(gen);
            return;
        }
        Class<?> cls = value.getClass();
        ValueSerializer<Object> ser = this.findTypedValueSerializer(cls, true);
        PropertyName rootName = this._config.getFullRootName();
        if (rootName == null) {
            if (this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                this._serialize(gen, value, ser, this.findRootName(cls));
                return;
            }
        } else if (!rootName.isEmpty()) {
            this._serialize(gen, value, ser, rootName);
            return;
        }
        this._serialize(gen, value, ser);
    }

    public void serializeValue(JsonGenerator gen, Object value, JavaType rootType) throws JacksonException {
        this._assignGenerator(gen);
        if (value == null) {
            this._serializeNull(gen);
            return;
        }
        if (!rootType.getRawClass().isAssignableFrom(value.getClass())) {
            this._reportIncompatibleRootType(value, rootType);
        }
        ValueSerializer<Object> ser = this.findTypedValueSerializer(rootType, true);
        PropertyName rootName = this._config.getFullRootName();
        if (rootName == null) {
            if (this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                this._serialize(gen, value, ser, this.findRootName(rootType));
                return;
            }
        } else if (!rootName.isEmpty()) {
            this._serialize(gen, value, ser, rootName);
            return;
        }
        this._serialize(gen, value, ser);
    }

    public void serializeValue(JsonGenerator gen, Object value, JavaType rootType, ValueSerializer<Object> ser) throws JacksonException {
        PropertyName rootName;
        this._assignGenerator(gen);
        if (value == null) {
            this._serializeNull(gen);
            return;
        }
        if (rootType != null && !rootType.getRawClass().isAssignableFrom(value.getClass())) {
            this._reportIncompatibleRootType(value, rootType);
        }
        if (ser == null) {
            ser = this.findTypedValueSerializer(rootType, true);
        }
        if ((rootName = this._config.getFullRootName()) == null) {
            if (this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                rootName = rootType == null ? this.findRootName(value.getClass()) : this.findRootName(rootType);
                this._serialize(gen, value, ser, rootName);
                return;
            }
        } else if (!rootName.isEmpty()) {
            this._serialize(gen, value, ser, rootName);
            return;
        }
        this._serialize(gen, value, ser);
    }

    public void serializePolymorphic(JsonGenerator gen, Object value, JavaType rootType, ValueSerializer<Object> valueSer, TypeSerializer typeSer) throws JacksonException {
        boolean wrap;
        PropertyName rootName;
        this._assignGenerator(gen);
        if (value == null) {
            this._serializeNull(gen);
            return;
        }
        if (rootType != null && !rootType.getRawClass().isAssignableFrom(value.getClass())) {
            this._reportIncompatibleRootType(value, rootType);
        }
        if (valueSer == null) {
            valueSer = rootType != null && rootType.isContainerType() ? this.handleRootContextualization(this.findValueSerializer(rootType)) : this.handleRootContextualization(this.findValueSerializer(value.getClass()));
        }
        if ((rootName = this._config.getFullRootName()) == null) {
            wrap = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
            if (wrap) {
                gen.writeStartObject();
                PropertyName pname = this.findRootName(value.getClass());
                gen.writeName(pname.simpleAsEncoded(this._config));
            }
        } else if (rootName.isEmpty()) {
            wrap = false;
        } else {
            wrap = true;
            gen.writeStartObject();
            gen.writeName(rootName.getSimpleName());
        }
        valueSer.serializeWithType(value, gen, this, typeSer);
        if (wrap) {
            gen.writeEndObject();
        }
    }

    private final void _serialize(JsonGenerator gen, Object value, ValueSerializer<Object> ser, PropertyName rootName) throws JacksonException {
        gen.writeStartObject();
        gen.writeName(rootName.simpleAsEncoded(this._config));
        ser.serialize(value, gen, this);
        gen.writeEndObject();
    }

    private final void _serialize(JsonGenerator gen, Object value, ValueSerializer<Object> ser) throws JacksonException {
        ser.serialize(value, gen, this);
    }

    protected void _serializeNull(JsonGenerator gen) throws JacksonException {
        ValueSerializer<Object> ser = this.getDefaultNullValueSerializer();
        ser.serialize(null, gen, this);
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper visitor) {
        Objects.requireNonNull(javaType);
        visitor.setContext(this);
        this.findRootValueSerializer(javaType).acceptJsonFormatVisitor(visitor, javaType);
    }

    private void _assignGenerator(JsonGenerator g) {
        this._generator = g;
        this._writeCapabilities = g.streamWriteCapabilities();
    }

    public static final class Impl
    extends SerializationContextExt {
        public Impl(TokenStreamFactory streamFactory, SerializationConfig config, GeneratorSettings genSettings, SerializerFactory f, SerializerCache cache) {
            super(streamFactory, config, genSettings, f, cache);
        }
    }
}

