/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedAndMetadata;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedConstructor;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.introspect.ObjectIdInfo;
import tools.jackson.databind.introspect.POJOPropertiesCollector;
import tools.jackson.databind.introspect.PotentialCreators;
import tools.jackson.databind.util.Annotations;
import tools.jackson.databind.util.ClassUtil;

public class BasicBeanDescription
extends BeanDescription {
    private static final Class<?>[] NO_VIEWS = new Class[0];
    protected final POJOPropertiesCollector _propCollector;
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _intr;
    protected final AnnotatedClass _classInfo;
    protected Class<?>[] _defaultViews;
    protected boolean _defaultViewsResolved;
    protected List<BeanPropertyDefinition> _properties;
    protected ObjectIdInfo _objectIdInfo;
    protected transient JsonFormat.Value _classFormat;

    protected BasicBeanDescription(POJOPropertiesCollector coll, JavaType type, AnnotatedClass classDef) {
        super(type);
        this._propCollector = coll;
        this._config = Objects.requireNonNull(coll.getConfig());
        this._intr = this._config.getAnnotationIntrospector();
        this._classInfo = classDef;
    }

    protected BasicBeanDescription(MapperConfig<?> config, JavaType type, AnnotatedClass classDef) {
        super(type);
        this._propCollector = null;
        this._config = Objects.requireNonNull(config);
        this._intr = this._config.getAnnotationIntrospector();
        this._classInfo = classDef;
        this._properties = Collections.emptyList();
    }

    protected BasicBeanDescription(POJOPropertiesCollector coll) {
        this(coll, coll.getType(), coll.getClassDef());
        this._objectIdInfo = coll.getObjectIdInfo();
    }

    public static BasicBeanDescription forDeserialization(POJOPropertiesCollector coll) {
        return new BasicBeanDescription(coll);
    }

    public static BasicBeanDescription forSerialization(POJOPropertiesCollector coll) {
        return new BasicBeanDescription(coll);
    }

    public static BasicBeanDescription forOtherUse(MapperConfig<?> config, JavaType type, AnnotatedClass ac) {
        return new BasicBeanDescription(config, type, ac);
    }

    protected List<BeanPropertyDefinition> _properties() {
        if (this._properties == null) {
            this._properties = this._propCollector.getProperties();
        }
        return this._properties;
    }

    @Override
    public BeanDescription.Supplier supplier() {
        return new BeanDescription.EagerSupplier(this._config, this);
    }

    public boolean removeProperty(String propName) {
        Iterator<BeanPropertyDefinition> it = this._properties().iterator();
        while (it.hasNext()) {
            BeanPropertyDefinition prop = it.next();
            if (!prop.getName().equals(propName)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public boolean addProperty(BeanPropertyDefinition def) {
        if (this.hasProperty(def.getFullName())) {
            return false;
        }
        this._properties().add(def);
        return true;
    }

    public boolean hasProperty(PropertyName name) {
        return this.findProperty(name) != null;
    }

    public BeanPropertyDefinition findProperty(PropertyName name) {
        for (BeanPropertyDefinition prop : this._properties()) {
            if (!prop.hasName(name)) continue;
            return prop;
        }
        return null;
    }

    @Override
    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    @Override
    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    @Override
    public List<BeanPropertyDefinition> findProperties() {
        return this._properties();
    }

    @Override
    public AnnotatedMember findJsonKeyAccessor() {
        return this._propCollector == null ? null : this._propCollector.getJsonKeyAccessor();
    }

    @Override
    public AnnotatedMember findJsonValueAccessor() {
        return this._propCollector == null ? null : this._propCollector.getJsonValueAccessor();
    }

    @Override
    public Set<String> getIgnoredPropertyNames() {
        Set<String> ign;
        Set<String> set = ign = this._propCollector == null ? null : this._propCollector.getIgnoredPropertyNames();
        if (ign == null) {
            return Collections.emptySet();
        }
        return ign;
    }

    @Override
    public boolean hasKnownClassAnnotations() {
        return this._classInfo.hasAnnotations();
    }

    @Override
    public Annotations getClassAnnotations() {
        return this._classInfo.getAnnotations();
    }

    @Override
    public AnnotatedConstructor findDefaultConstructor() {
        return this._classInfo.getDefaultConstructor();
    }

    @Override
    public AnnotatedMember findAnySetterAccessor() throws IllegalArgumentException {
        if (this._propCollector != null) {
            AnnotatedMethod anyMethod = this._propCollector.getAnySetterMethod();
            if (anyMethod != null) {
                Class<?> type = anyMethod.getRawParameterType(0);
                if (type != String.class && type != Object.class) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-setter' annotation on method '%s()': first argument not of type String or Object, but %s", anyMethod.getName(), type.getName()));
                }
                return anyMethod;
            }
            AnnotatedMember anyField = this._propCollector.getAnySetterField();
            if (anyField != null) {
                Class<?> type = anyField.getRawType();
                if (!Map.class.isAssignableFrom(type) && !JsonNode.class.isAssignableFrom(type)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-setter' annotation on field '%s': type is not instance of `java.util.Map` or `JsonNode`", anyField.getName()));
                }
                return anyField;
            }
        }
        return null;
    }

    @Override
    public Map<Object, AnnotatedMember> findInjectables() {
        if (this._propCollector != null) {
            return this._propCollector.getInjectables();
        }
        return Collections.emptyMap();
    }

    @Override
    public List<AnnotatedConstructor> getConstructors() {
        return this._classInfo.getConstructors();
    }

    @Override
    public List<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> getConstructorsWithMode() {
        List<AnnotatedConstructor> allCtors = this._classInfo.getConstructors();
        if (allCtors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> result = new ArrayList<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>>();
        for (AnnotatedConstructor ctor : allCtors) {
            JsonCreator.Mode mode = this._intr.findCreatorAnnotation(this._config, ctor);
            if (mode == JsonCreator.Mode.DISABLED) continue;
            result.add(AnnotatedAndMetadata.of(ctor, mode));
        }
        return result;
    }

    @Override
    public PotentialCreators getPotentialCreators() {
        if (this._propCollector == null) {
            return new PotentialCreators();
        }
        return this._propCollector.getPotentialCreators();
    }

    @Override
    public Object instantiateBean(boolean fixAccess) {
        AnnotatedConstructor ac = this._classInfo.getDefaultConstructor();
        if (ac == null) {
            return null;
        }
        if (fixAccess) {
            ac.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        try {
            return ac.call();
        }
        catch (Exception e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            ClassUtil.throwIfError(t);
            ClassUtil.throwIfRTE(t);
            throw new IllegalArgumentException("Failed to instantiate bean of type " + ClassUtil.nameOf(this._classInfo.getAnnotated()) + ": (" + t.getClass().getName() + ") " + ClassUtil.exceptionMessage(t), t);
        }
    }

    @Override
    public AnnotatedMethod findMethod(String name, Class<?>[] paramTypes) {
        return this._classInfo.findMethod(name, paramTypes);
    }

    @Override
    public Class<?>[] findDefaultViews() {
        if (!this._defaultViewsResolved) {
            this._defaultViewsResolved = true;
            Class<?>[] def = this._intr.findViews(this._config, this._classInfo);
            if (def == null && !this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION)) {
                def = NO_VIEWS;
            }
            this._defaultViews = def;
        }
        return this._defaultViews;
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(JsonInclude.Value defValue) {
        JsonInclude.Value incl = this._intr.findPropertyInclusion(this._config, this._classInfo);
        if (incl != null) {
            return defValue == null ? incl : defValue.withOverrides(incl);
        }
        return defValue;
    }

    @Override
    public AnnotatedMember findAnyGetter() throws IllegalArgumentException {
        if (this._propCollector != null) {
            AnnotatedMember anyGetter = this._propCollector.getAnyGetterMethod();
            if (anyGetter != null) {
                Class<?> type = anyGetter.getRawType();
                if (!Map.class.isAssignableFrom(type)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-getter' annotation on method %s(): return type is not instance of java.util.Map", anyGetter.getName()));
                }
                return anyGetter;
            }
            AnnotatedMember anyField = this._propCollector.getAnyGetterField();
            if (anyField != null) {
                Class<?> type = anyField.getRawType();
                if (!Map.class.isAssignableFrom(type)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-getter' annotation on field '%s': type is not instance of java.util.Map", anyField.getName()));
                }
                return anyField;
            }
        }
        return null;
    }

    @Override
    public List<BeanPropertyDefinition> findBackReferences() {
        ArrayList<BeanPropertyDefinition> result = null;
        HashSet<String> names = null;
        for (BeanPropertyDefinition property : this._properties()) {
            AnnotationIntrospector.ReferenceProperty refDef = property.findReferenceType();
            if (refDef == null || !refDef.isBackReference()) continue;
            String refName = refDef.getName();
            if (result == null) {
                result = new ArrayList<BeanPropertyDefinition>();
                names = new HashSet<String>();
                names.add(refName);
            } else if (!names.add(refName)) {
                throw new IllegalArgumentException("Multiple back-reference properties with name " + ClassUtil.name(refName));
            }
            result.add(property);
        }
        return result;
    }

    @Override
    public List<AnnotatedMethod> getFactoryMethods() {
        List<AnnotatedMethod> candidates = this._classInfo.getFactoryMethods();
        if (candidates.isEmpty()) {
            return candidates;
        }
        ArrayList<AnnotatedMethod> result = null;
        for (AnnotatedMethod am : candidates) {
            if (!this.isFactoryMethod(am)) continue;
            if (result == null) {
                result = new ArrayList<AnnotatedMethod>();
            }
            result.add(am);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> getFactoryMethodsWithMode() {
        List<AnnotatedMethod> candidates = this._classInfo.getFactoryMethods();
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> result = null;
        for (AnnotatedMethod am : candidates) {
            AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> match = this.findFactoryMethodMetadata(am);
            if (match == null) continue;
            if (result == null) {
                result = new ArrayList<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>>();
            }
            result.add(match);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    protected boolean isFactoryMethod(AnnotatedMethod am) {
        Class<?> cls;
        Class<?> rt = am.getRawReturnType();
        if (!this.getBeanClass().isAssignableFrom(rt)) {
            return false;
        }
        JsonCreator.Mode mode = this._intr.findCreatorAnnotation(this._config, am);
        if (mode != null && mode != JsonCreator.Mode.DISABLED) {
            return true;
        }
        String name = am.getName();
        if ("valueOf".equals(name) && am.getParameterCount() == 1) {
            return true;
        }
        return "fromString".equals(name) && am.getParameterCount() == 1 && ((cls = am.getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom(cls));
    }

    protected AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> findFactoryMethodMetadata(AnnotatedMethod am) {
        Class<?> cls;
        Class<?> rt = am.getRawReturnType();
        if (!this.getBeanClass().isAssignableFrom(rt)) {
            return null;
        }
        JsonCreator.Mode mode = this._intr.findCreatorAnnotation(this._config, am);
        if (mode != null) {
            if (mode == JsonCreator.Mode.DISABLED) {
                return null;
            }
            return AnnotatedAndMetadata.of(am, mode);
        }
        String name = am.getName();
        if ("valueOf".equals(name) && am.getParameterCount() == 1) {
            return AnnotatedAndMetadata.of(am, mode);
        }
        if ("fromString".equals(name) && am.getParameterCount() == 1 && ((cls = am.getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom(cls))) {
            return AnnotatedAndMetadata.of(am, mode);
        }
        return null;
    }
}

