/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.impl;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.introspect.AnnotatedMember;

public class MergingSettableBeanProperty
extends SettableBeanProperty.Delegating {
    protected final AnnotatedMember _accessor;

    protected MergingSettableBeanProperty(SettableBeanProperty delegate, AnnotatedMember accessor) {
        super(delegate);
        this._accessor = accessor;
    }

    protected MergingSettableBeanProperty(MergingSettableBeanProperty src, SettableBeanProperty delegate) {
        super(delegate);
        this._accessor = src._accessor;
    }

    public static MergingSettableBeanProperty construct(SettableBeanProperty delegate, AnnotatedMember accessor) {
        return new MergingSettableBeanProperty(delegate, accessor);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty d) {
        return new MergingSettableBeanProperty(d, this._accessor);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        Object oldValue = this._accessor.getValue(instance);
        Object newValue = oldValue == null ? this.delegate.deserialize(p, ctxt) : this.delegate.deserializeWith(p, ctxt, oldValue);
        if (newValue != oldValue) {
            this.delegate.set(ctxt, instance, newValue);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        Object oldValue = this._accessor.getValue(instance);
        Object newValue = oldValue == null ? this.delegate.deserialize(p, ctxt) : this.delegate.deserializeWith(p, ctxt, oldValue);
        if (newValue != oldValue && newValue != null) {
            return this.delegate.setAndReturn(ctxt, instance, newValue);
        }
        return instance;
    }

    @Override
    public void set(DeserializationContext ctxt, Object instance, Object value) {
        if (value != null) {
            this.delegate.set(ctxt, instance, value);
        }
    }

    @Override
    public Object setAndReturn(DeserializationContext ctxt, Object instance, Object value) {
        if (value != null) {
            return this.delegate.setAndReturn(ctxt, instance, value);
        }
        return instance;
    }
}

