/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.bean;

import com.fasterxml.jackson.annotation.JacksonInject;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedParameter;
import tools.jackson.databind.introspect.AnnotatedWithParams;
import tools.jackson.databind.introspect.BeanPropertyDefinition;

public final class CreatorCandidate {
    protected final MapperConfig<?> _config;
    protected final AnnotatedWithParams _creator;
    protected final int _paramCount;
    protected final Param[] _params;

    protected CreatorCandidate(MapperConfig<?> config, AnnotatedWithParams ct, Param[] params, int count) {
        this._config = config;
        this._creator = ct;
        this._params = params;
        this._paramCount = count;
    }

    public static CreatorCandidate construct(MapperConfig<?> config, AnnotatedWithParams creator, BeanPropertyDefinition[] propDefs) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        int pcount = creator.getParameterCount();
        Param[] params = new Param[pcount];
        for (int i = 0; i < pcount; ++i) {
            AnnotatedParameter annParam = creator.getParameter(i);
            JacksonInject.Value injectId = intr.findInjectableValue(config, annParam);
            params[i] = new Param(annParam, propDefs == null ? null : propDefs[i], injectId);
        }
        return new CreatorCandidate(config, creator, params, pcount);
    }

    public AnnotatedWithParams creator() {
        return this._creator;
    }

    public int paramCount() {
        return this._paramCount;
    }

    public JacksonInject.Value injection(int i) {
        return this._params[i].injection;
    }

    public AnnotatedParameter parameter(int i) {
        return this._params[i].annotated;
    }

    public BeanPropertyDefinition propertyDef(int i) {
        return this._params[i].propDef;
    }

    public PropertyName paramName(int i) {
        BeanPropertyDefinition propDef = this._params[i].propDef;
        if (propDef != null) {
            return propDef.getFullName();
        }
        return null;
    }

    public PropertyName explicitParamName(int i) {
        BeanPropertyDefinition propDef = this._params[i].propDef;
        if (propDef != null && propDef.isExplicitlyNamed()) {
            return propDef.getFullName();
        }
        return null;
    }

    public String toString() {
        return this._creator.toString();
    }

    public static final class Param {
        public final AnnotatedParameter annotated;
        public final BeanPropertyDefinition propDef;
        public final JacksonInject.Value injection;

        public Param(AnnotatedParameter p, BeanPropertyDefinition pd, JacksonInject.Value i) {
            this.annotated = p;
            this.propDef = pd;
            this.injection = i;
        }

        public PropertyName fullName() {
            if (this.propDef == null) {
                return null;
            }
            return this.propDef.getFullName();
        }

        public boolean hasFullName() {
            if (this.propDef == null) {
                return false;
            }
            PropertyName n = this.propDef.getFullName();
            return n.hasSimpleName();
        }
    }
}

