/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.orderbyhelper;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import tk.mybatis.orderbyhelper.OrderByParser;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class OrderByHelper
implements Interceptor {
    private static final ThreadLocal<String> ORDERBY_LOCAL = new ThreadLocal();
    private static Field additionalParametersField;

    public static void orderBy(String orderBy) {
        ORDERBY_LOCAL.set(orderBy);
    }

    public static void clear() {
        ORDERBY_LOCAL.remove();
    }

    public Object intercept(Invocation invocation) throws Throwable {
        String orderBy = ORDERBY_LOCAL.get();
        if (orderBy != null && orderBy.length() > 0) {
            CacheKey cacheKey;
            BoundSql boundSql;
            ORDERBY_LOCAL.remove();
            Object[] args = invocation.getArgs();
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            RowBounds rowBounds = (RowBounds)args[2];
            ResultHandler resultHandler = (ResultHandler)args[3];
            Executor executor = (Executor)invocation.getTarget();
            if (args.length == 4) {
                boundSql = ms.getBoundSql(parameter);
                cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
            } else {
                cacheKey = (CacheKey)args[4];
                boundSql = (BoundSql)args[5];
            }
            String sql = boundSql.getSql();
            String orderBySql = OrderByParser.converToOrderBySql(sql, orderBy);
            cacheKey.update((Object)orderBy);
            BoundSql orderbyBoundSql = new BoundSql(ms.getConfiguration(), orderBySql, boundSql.getParameterMappings(), parameter);
            Map additionalParameters = (Map)additionalParametersField.get(boundSql);
            for (String key : additionalParameters.keySet()) {
                orderbyBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
            }
            return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, orderbyBoundSql);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    static {
        try {
            additionalParametersField = BoundSql.class.getDeclaredField("additionalParameters");
            additionalParametersField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

