/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.utils;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.matchers.AnnotationMatcherUtils;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.utils.MoreMatchers;

public final class MoreJUnitMatchers {
    public static final MultiMatcher<MethodTree, AnnotationTree> TEST_METHOD = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"org.junit.jupiter.api.Test"), MoreMatchers.hasMetaAnnotation("org.junit.jupiter.api.TestTemplate")}));
    public static final MultiMatcher<MethodTree, AnnotationTree> SETUP_OR_TEARDOWN_METHOD = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"org.junit.jupiter.api.AfterAll"), Matchers.isType((String)"org.junit.jupiter.api.AfterEach"), Matchers.isType((String)"org.junit.jupiter.api.BeforeAll"), Matchers.isType((String)"org.junit.jupiter.api.BeforeEach")}));
    public static final MultiMatcher<MethodTree, AnnotationTree> HAS_METHOD_SOURCE = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)"org.junit.jupiter.params.provider.MethodSource"));

    private MoreJUnitMatchers() {
    }

    public static ImmutableList<String> getMethodSourceFactoryNames(AnnotationTree methodSourceAnnotation, MethodTree method) {
        return (ImmutableList)MoreJUnitMatchers.getMethodSourceFactoryDescriptors(methodSourceAnnotation, method).stream().map(descriptor -> {
            int index = descriptor.indexOf(40);
            return index < 0 ? descriptor : descriptor.substring(0, index);
        }).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<String> getMethodSourceFactoryDescriptors(AnnotationTree methodSourceAnnotation, MethodTree method) {
        String methodName = method.getName().toString();
        ExpressionTree value = AnnotationMatcherUtils.getArgument((AnnotationTree)methodSourceAnnotation, (String)"value");
        if (!(value instanceof NewArrayTree)) {
            return ImmutableList.of((Object)MoreJUnitMatchers.toMethodSourceFactoryDescriptor(value, methodName));
        }
        NewArrayTree newArray = (NewArrayTree)value;
        return (ImmutableList)newArray.getInitializers().stream().map(name -> MoreJUnitMatchers.toMethodSourceFactoryDescriptor(name, methodName)).collect(ImmutableList.toImmutableList());
    }

    private static String toMethodSourceFactoryDescriptor(@Nullable ExpressionTree tree, String annotatedMethodName) {
        return Objects.requireNonNullElse(Strings.emptyToNull((String)((String)ASTHelpers.constValue((Tree)tree, String.class))), annotatedMethodName);
    }
}

