/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.FileAnnotation;
import tech.grasshopper.pdf.annotation.file.FileAnnotationStore;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.structure.Display;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.TableCreator;
import tech.grasshopper.pdf.structure.cell.TextFileLinkCell;

public class RestAssuredDisplay
extends Display {
    private float finalY;
    private List<Map<String, String>> data;
    protected FileAnnotationStore fileAnnotations;
    private static final float GAP = 10.0f;

    public void display() {
        this.data.forEach(d -> {
            Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(new float[]{80.0f, 50.0f, 250.0f, 80.0f, 300.0f}).borderWidth(1.0f).borderColor(Color.GRAY).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.MIDDLE).addRow(Row.builder().fontSize(Integer.valueOf(13)).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().font(ReportFont.BOLD_ITALIC_FONT)).text((String)d.get("Method")).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().font(ReportFont.BOLD_ITALIC_FONT)).text((String)d.get("Status Code")).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().fontSize(Integer.valueOf(10))).text((String)d.get("Endpoint")).colSpan(3)).font(ReportFont.ITALIC_FONT)).build()).build()).addRow(Row.builder().fontSize(Integer.valueOf(12)).font(ReportFont.ITALIC_FONT).add((AbstractCell)TextCell.builder().text("Request").build()).add(this.createDataFileDisplay("Request", (Map<String, String>)d, 2)).add((AbstractCell)TextCell.builder().text("Response").build()).add(this.createDataFileDisplay("Response", (Map<String, String>)d, 1)).build());
            TableCreator tableCreator = TableCreator.builder().tableBuilder(tableBuilder).document(this.document).startX(40.0f).startY(this.ylocation).endY(20.0f).repeatRows(2).pageSupplier(PageCreator.builder().document(this.document).build().landscapePageWithHeaderAndNumberSupplier("DETAILED SECTION")).build();
            tableCreator.displayTable();
            this.finalY = tableCreator.getFinalY();
            this.ylocation = this.finalY - 10.0f;
        });
    }

    private AbstractCell createDataFileDisplay(String reqres, Map<String, String> data, int colSpan) {
        String[] types = new String[]{"Body", "Headers", "Cookies"};
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        StringBuffer textSbr = new StringBuffer();
        for (String type : types) {
            if (!data.containsKey(reqres + " " + type)) continue;
            annotations.add(FileAnnotation.builder().text(type).link(data.get(reqres + " " + type)).build());
            textSbr.append(type).append("  ");
        }
        if (annotations.isEmpty()) {
            return ((TextCell.TextCellBuilder)TextCell.builder().text("").colSpan(colSpan)).build();
        }
        this.fileAnnotations.addFileAnnotations(annotations);
        return ((TextFileLinkCell.TextFileLinkCellBuilder)((TextFileLinkCell.TextFileLinkCellBuilder)TextFileLinkCell.builder().text(textSbr.toString())).annotations(annotations).colSpan(colSpan)).build();
    }

    protected RestAssuredDisplay(RestAssuredDisplayBuilder<?, ?> b) {
        super(b);
        this.finalY = ((RestAssuredDisplayBuilder)b).finalY;
        this.data = ((RestAssuredDisplayBuilder)b).data;
        this.fileAnnotations = ((RestAssuredDisplayBuilder)b).fileAnnotations;
    }

    public static RestAssuredDisplayBuilder<?, ?> builder() {
        return new RestAssuredDisplayBuilderImpl();
    }

    public List<Map<String, String>> getData() {
        return this.data;
    }

    public FileAnnotationStore getFileAnnotations() {
        return this.fileAnnotations;
    }

    public void setFinalY(float finalY) {
        this.finalY = finalY;
    }

    public void setData(List<Map<String, String>> data) {
        this.data = data;
    }

    public void setFileAnnotations(FileAnnotationStore fileAnnotations) {
        this.fileAnnotations = fileAnnotations;
    }

    public String toString() {
        return "RestAssuredDisplay(finalY=" + this.getFinalY() + ", data=" + this.getData() + ", fileAnnotations=" + this.getFileAnnotations() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestAssuredDisplay)) {
            return false;
        }
        RestAssuredDisplay other = (RestAssuredDisplay)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (Float.compare(this.getFinalY(), other.getFinalY()) != 0) {
            return false;
        }
        List<Map<String, String>> this$data = this.getData();
        List<Map<String, String>> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        FileAnnotationStore this$fileAnnotations = this.getFileAnnotations();
        FileAnnotationStore other$fileAnnotations = other.getFileAnnotations();
        return !(this$fileAnnotations == null ? other$fileAnnotations != null : !((Object)this$fileAnnotations).equals(other$fileAnnotations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestAssuredDisplay;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getFinalY());
        List<Map<String, String>> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        FileAnnotationStore $fileAnnotations = this.getFileAnnotations();
        result = result * 59 + ($fileAnnotations == null ? 43 : ((Object)$fileAnnotations).hashCode());
        return result;
    }

    public float getFinalY() {
        return this.finalY;
    }

    private static final class RestAssuredDisplayBuilderImpl
    extends RestAssuredDisplayBuilder<RestAssuredDisplay, RestAssuredDisplayBuilderImpl> {
        private RestAssuredDisplayBuilderImpl() {
        }

        @Override
        protected RestAssuredDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public RestAssuredDisplay build() {
            return new RestAssuredDisplay(this);
        }
    }

    public static abstract class RestAssuredDisplayBuilder<C extends RestAssuredDisplay, B extends RestAssuredDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private float finalY;
        private List<Map<String, String>> data;
        private FileAnnotationStore fileAnnotations;

        protected abstract B self();

        public abstract C build();

        public B finalY(float finalY) {
            this.finalY = finalY;
            return (B)this.self();
        }

        public B data(List<Map<String, String>> data) {
            this.data = data;
            return (B)this.self();
        }

        public B fileAnnotations(FileAnnotationStore fileAnnotations) {
            this.fileAnnotations = fileAnnotations;
            return (B)this.self();
        }

        public String toString() {
            return "RestAssuredDisplay.RestAssuredDisplayBuilder(super=" + super.toString() + ", finalY=" + this.finalY + ", data=" + this.data + ", fileAnnotations=" + this.fileAnnotations + ")";
        }
    }
}

