/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.tabledrawer;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.function.BiConsumer;
import org.vandeseer.easytable.RepeatedHeaderTableDrawer;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.structure.Row;

public class ExecutableTableDrawer
extends RepeatedHeaderTableDrawer {
    protected void drawWithFunction(TableDrawer.PageData pageData, Point2D.Float startingPoint, BiConsumer<Drawer, DrawingContext> consumer) {
        float y = startingPoint.y;
        for (int rowIndex = pageData.firstRowOnPage; rowIndex < pageData.firstRowOnNextPage; ++rowIndex) {
            Row row = (Row)this.table.getRows().get(rowIndex);
            y -= row.getHeight();
            if (rowIndex + 1 == pageData.firstRowOnNextPage) {
                row.getCells().forEach(c -> {
                    c.getSettings().setBorderWidthBottom(Float.valueOf(1.0f));
                    c.getSettings().setBorderColor(Color.GRAY);
                });
            }
            this.drawRow(new Point2D.Float(startingPoint.x, y), row, rowIndex, consumer);
            this.finalY = y;
        }
    }

    protected ExecutableTableDrawer(ExecutableTableDrawerBuilder<?, ?> b) {
        super(b);
    }

    public static ExecutableTableDrawerBuilder<?, ?> builder() {
        return new ExecutableTableDrawerBuilderImpl();
    }

    private static final class ExecutableTableDrawerBuilderImpl
    extends ExecutableTableDrawerBuilder<ExecutableTableDrawer, ExecutableTableDrawerBuilderImpl> {
        private ExecutableTableDrawerBuilderImpl() {
        }

        @Override
        protected ExecutableTableDrawerBuilderImpl self() {
            return this;
        }

        @Override
        public ExecutableTableDrawer build() {
            return new ExecutableTableDrawer(this);
        }
    }

    public static abstract class ExecutableTableDrawerBuilder<C extends ExecutableTableDrawer, B extends ExecutableTableDrawerBuilder<C, B>>
    extends RepeatedHeaderTableDrawer.RepeatedHeaderTableDrawerBuilder<C, B> {
        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ExecutableTableDrawer.ExecutableTableDrawerBuilder(super=" + super.toString() + ")";
        }
    }
}

