/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure.header;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.vandeseer.easytable.drawing.DrawingUtil;
import org.vandeseer.easytable.drawing.PositionedStyledText;
import tech.grasshopper.pdf.font.ReportFont;

public class PageTitle {
    private PDPageContentStream content;
    private String title;

    public void displayTitle() {
        PositionedStyledText textDetails = PositionedStyledText.builder().x(50.0f).y(570.0f).text(this.title).font(ReportFont.ITALIC_FONT).fontSize(11).color(Color.LIGHT_GRAY).build();
        DrawingUtil.drawText((PDPageContentStream)this.content, (PositionedStyledText)textDetails);
    }

    PageTitle(PDPageContentStream content, String title) {
        this.content = content;
        this.title = title;
    }

    public static PageTitleBuilder builder() {
        return new PageTitleBuilder();
    }

    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static class PageTitleBuilder {
        private PDPageContentStream content;
        private String title;

        PageTitleBuilder() {
        }

        public PageTitleBuilder content(PDPageContentStream content) {
            this.content = content;
            return this;
        }

        public PageTitleBuilder title(String title) {
            this.title = title;
            return this;
        }

        public PageTitle build() {
            return new PageTitle(this.content, this.title);
        }

        public String toString() {
            return "PageTitle.PageTitleBuilder(content=" + this.content + ", title=" + this.title + ")";
        }
    }
}

