/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.image;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.internal.chartpart.Chart;

public class ImageCreator {
    private Chart<?, ?> chart;
    private PDDocument document;
    private PDPageContentStream content;

    public PDImageXObject generateChartImageXObject() {
        byte[] bytes = BitmapEncoder.getBitmapBytes(this.chart, (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
        return PDImageXObject.createFromByteArray((PDDocument)this.document, (byte[])bytes, (String)"");
    }

    public void generateAndDisplayChartImage(float xLocation, float yLocation) {
        this.content.drawImage(this.generateChartImageXObject(), xLocation, yLocation);
    }

    ImageCreator(Chart<?, ?> chart, PDDocument document, PDPageContentStream content) {
        this.chart = chart;
        this.document = document;
        this.content = content;
    }

    public static ImageCreatorBuilder builder() {
        return new ImageCreatorBuilder();
    }

    public static class ImageCreatorBuilder {
        private Chart<?, ?> chart;
        private PDDocument document;
        private PDPageContentStream content;

        ImageCreatorBuilder() {
        }

        public ImageCreatorBuilder chart(Chart<?, ?> chart) {
            this.chart = chart;
            return this;
        }

        public ImageCreatorBuilder document(PDDocument document) {
            this.document = document;
            return this;
        }

        public ImageCreatorBuilder content(PDPageContentStream content) {
            this.content = content;
            return this;
        }

        public ImageCreator build() {
            return new ImageCreator(this.chart, this.document, this.content);
        }

        public String toString() {
            return "ImageCreator.ImageCreatorBuilder(chart=" + this.chart + ", document=" + this.document + ", content=" + this.content + ")";
        }
    }
}

