/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chart;

import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.Styler;
import tech.grasshopper.pdf.chart.BarChartSeriesData;
import tech.grasshopper.pdf.chart.CustomStyler;

public class ReportBarChart
extends CategoryChart
implements CustomStyler,
BarChartSeriesData {
    public ReportBarChart(int width, int height) {
        super(width, height, Styler.ChartTheme.XChart);
        this.updateStyler();
    }

    @Override
    public void updateStyler() {
        CategoryStyler styler = (CategoryStyler)this.getStyler();
        styler.setLegendVisible(false);
        styler.setPlotContentSize(0.98);
        styler.setChartPadding(3);
        styler.setHasAnnotations(false);
        styler.setAvailableSpaceFill(0.2);
        styler.setChartBackgroundColor(Color.WHITE);
    }

    @Override
    public void updateData(List<? extends Number> data) {
        List xData = IntStream.rangeClosed(1, data.size()).boxed().collect(Collectors.toList());
        this.addSeries("data", xData, data);
    }
}

