/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import io.netty.handler.codec.http.HttpRequest;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.littleshoot.proxy.ChainedProxy;
import org.littleshoot.proxy.ChainedProxyAdapter;
import org.littleshoot.proxy.ChainedProxyManager;

public class ProxyOverrider
implements ChainedProxyManager {
    private final Map<String, InetSocketAddress> originalProxies = new LinkedHashMap<String, InetSocketAddress>();
    private final Collection<String> originalNonProxyHosts = new HashSet<String>();

    public void activate(InetAddress host, int port, Collection<String> nonProxyHosts) {
        for (String scheme : new String[]{"http", "https"}) {
            String currentProxyHost = System.getProperty(scheme + ".proxyHost");
            String currentProxyPort = System.getProperty(scheme + ".proxyPort");
            if (currentProxyHost != null) {
                this.originalProxies.put(scheme, new InetSocketAddress(currentProxyHost, Integer.parseInt(currentProxyPort)));
            }
            System.setProperty(scheme + ".proxyHost", new InetSocketAddress(host, port).getHostString());
            System.setProperty(scheme + ".proxyPort", Integer.toString(port));
        }
        String currentNonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (currentNonProxyHosts == null) {
            this.originalNonProxyHosts.clear();
        } else {
            for (String nonProxyHost : Splitter.on((char)'|').split((CharSequence)currentNonProxyHosts)) {
                this.originalNonProxyHosts.add(nonProxyHost);
            }
        }
        System.setProperty("http.nonProxyHosts", Joiner.on((char)'|').join(nonProxyHosts));
    }

    public void deactivateAll() {
        for (String scheme : new String[]{"http", "https"}) {
            InetSocketAddress originalProxy = this.originalProxies.remove(scheme);
            if (originalProxy != null) {
                System.setProperty(scheme + ".proxyHost", originalProxy.getHostName());
                System.setProperty(scheme + ".proxyPort", Integer.toString(originalProxy.getPort()));
                continue;
            }
            System.clearProperty(scheme + ".proxyHost");
            System.clearProperty(scheme + ".proxyPort");
        }
        if (this.originalNonProxyHosts.isEmpty()) {
            System.clearProperty("http.nonProxyHosts");
        } else {
            System.setProperty("http.nonProxyHosts", Joiner.on((char)'|').join(this.originalNonProxyHosts));
        }
        this.originalNonProxyHosts.clear();
    }

    @Deprecated
    public ProxySelector getOriginalProxySelector() {
        return new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                InetSocketAddress address = (InetSocketAddress)ProxyOverrider.this.originalProxies.get(uri.getScheme());
                if (address != null && !ProxyOverrider.this.originalNonProxyHosts.contains(uri.getHost())) {
                    return Collections.singletonList(new Proxy(Proxy.Type.HTTP, address));
                }
                return Collections.singletonList(Proxy.NO_PROXY);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        };
    }

    public void lookupChainedProxies(HttpRequest request, Queue<ChainedProxy> chainedProxies) {
        final InetSocketAddress originalProxy = this.originalProxies.get(URI.create(request.getUri()).getScheme());
        if (originalProxy != null) {
            ChainedProxyAdapter chainProxy = new ChainedProxyAdapter(){

                public InetSocketAddress getChainedProxyAddress() {
                    return originalProxy;
                }
            };
            chainedProxies.add((ChainedProxy)chainProxy);
        } else {
            chainedProxies.add(ChainedProxyAdapter.FALLBACK_TO_DIRECT_CONNECTION);
        }
    }
}

