/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.littleshoot.proxy.SslEngineSource;

public class DynamicSelfSignedSslEngineSource
implements SslEngineSource {
    private static final String PASSWORD = "changeit";
    private static final String PROTOCOL = "TLS";
    private final File keyStoreFile;
    private String host;
    private int port;
    private SSLContext sslContext;

    public DynamicSelfSignedSslEngineSource(String host, int port) {
        this.host = host;
        this.port = port;
        this.keyStoreFile = new File(host + ".jks");
        this.initializeKeyStore();
        this.initializeSSLContext();
    }

    public SSLEngine newSslEngine() {
        return this.sslContext.createSSLEngine(this.host, this.port);
    }

    public SSLEngine newSslEngine(String peerHost, int peerPort) {
        return this.sslContext.createSSLEngine(peerHost, peerPort);
    }

    private void initializeKeyStore() {
        String localBetamaxKeystore = "betamax-local.jks";
        if (!new File(localBetamaxKeystore).exists()) {
            try {
                InputStream betamaxKeystoreStream = this.getClass().getClassLoader().getResourceAsStream("betamax.jks");
                FileUtils.copyInputStreamToFile((InputStream)betamaxKeystoreStream, (File)new File(localBetamaxKeystore));
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
                return;
            }
        } else if (this.keyStoreFile.isFile()) {
            return;
        }
        this.nativeCall("keytool", "-genkey", "-alias", this.host, "-keysize", "4096", "-validity", "36500", "-keyalg", "RSA", "-dname", "CN=" + this.host, "-keypass", PASSWORD, "-storepass", PASSWORD, "-keystore", this.keyStoreFile.getName());
        this.nativeCall("keytool", "-certreq", "-file", this.host + ".csr", "-alias", this.host, "-keystore", this.keyStoreFile.getName(), "-storepass", PASSWORD);
        this.nativeCall("keytool", "-gencert", "-infile", this.host + ".csr", "-outfile", this.host + ".cert", "-alias", "betamax", "-keystore", localBetamaxKeystore, "-storepass", PASSWORD);
        this.nativeCall("keytool", "-importcert", "-file", this.host + ".cert", "-noprompt", "-trustcacerts", "-alias", this.host, "-keystore", this.keyStoreFile.getName(), "-storepass", PASSWORD);
    }

    private void initializeSSLContext() {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(this.keyStoreFile), PASSWORD.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, PASSWORD.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(ks);
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            KeyManager[] keyManagers = kmf.getKeyManagers();
            this.sslContext = SSLContext.getInstance(PROTOCOL);
            this.sslContext.init(keyManagers, trustManagers, null);
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the server-side SSLContext", e);
        }
    }

    private String nativeCall(String ... commands) {
        ProcessBuilder pb = new ProcessBuilder(commands);
        try {
            Process process = pb.start();
            InputStream is = process.getInputStream();
            return IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return "";
        }
    }
}

