/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.tape.yaml;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.representer.Representer;
import software.betamax.io.FileResolver;
import software.betamax.io.FilenameNormalizer;
import software.betamax.tape.Tape;
import software.betamax.tape.TapeLoadException;
import software.betamax.tape.TapeLoader;
import software.betamax.tape.yaml.TapeConstructor;
import software.betamax.tape.yaml.TapeRepresenter;
import software.betamax.tape.yaml.YamlTape;

public class YamlTapeLoader
implements TapeLoader<YamlTape> {
    public static final String FILE_CHARSET = "UTF-8";
    private final FileResolver fileResolver;
    private static final Logger LOG = Logger.getLogger(YamlTapeLoader.class.getName());

    public YamlTapeLoader(File tapeRoot) {
        this.fileResolver = new FileResolver(tapeRoot);
    }

    @Override
    public YamlTape loadTape(String name) {
        File file = this.fileFor(name);
        if (file.isFile()) {
            try {
                BufferedReader reader = Files.newReader((File)file, (Charset)Charset.forName(FILE_CHARSET));
                YamlTape tape = this.readFrom(reader);
                LOG.info(String.format("loaded tape with %d recorded interactions from file %s...", tape.size(), file.getAbsolutePath()));
                return tape;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.newTape(name);
    }

    @Override
    public void writeTape(Tape tape) {
        File file = this.fileFor(tape.getName());
        file.getParentFile().mkdirs();
        if (tape.isDirty()) {
            try {
                BufferedWriter bufferedWriter = Files.newWriter((File)file, (Charset)Charset.forName(FILE_CHARSET));
                LOG.info(String.format("writing tape %s to file %s...", tape.getName(), file.getAbsolutePath()));
                this.writeTo(tape, bufferedWriter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @VisibleForTesting
    public YamlTape newTape(String name) {
        YamlTape tape = new YamlTape(this.fileResolver);
        tape.setName(name);
        return tape;
    }

    @VisibleForTesting
    public YamlTape readFrom(Reader reader) {
        try {
            return (YamlTape)this.getYaml().load(reader);
        }
        catch (YAMLException e) {
            throw new TapeLoadException("Invalid tape", e);
        }
        catch (ClassCastException e) {
            throw new TapeLoadException("Invalid tape", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void writeTo(Tape tape, Writer writer) throws IOException {
        try {
            this.getYaml().dump((Object)tape, writer);
        }
        finally {
            writer.close();
        }
    }

    @Override
    public File fileFor(String tapeName) {
        String normalizedName = FilenameNormalizer.toFilename(tapeName);
        return this.fileResolver.toFile(normalizedName + ".yaml");
    }

    private Yaml getYaml() {
        TapeRepresenter representer = new TapeRepresenter(this.fileResolver);
        representer.addClassTag(YamlTape.class, YamlTape.TAPE_TAG);
        TapeConstructor constructor = new TapeConstructor(this.fileResolver);
        constructor.addTypeDescription(new TypeDescription(YamlTape.class, YamlTape.TAPE_TAG));
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setWidth(256);
        Yaml yaml = new Yaml((BaseConstructor)constructor, (Representer)representer, dumperOptions);
        yaml.setBeanAccess(BeanAccess.FIELD);
        return yaml;
    }
}

