/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.tape.yaml;

import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.beans.IntrospectionException;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;
import software.betamax.io.FileResolver;
import software.betamax.message.tape.RecordedRequest;
import software.betamax.message.tape.RecordedResponse;
import software.betamax.tape.RecordedInteraction;
import software.betamax.tape.Tape;
import software.betamax.tape.yaml.YamlTape;

public class TapeRepresenter
extends Representer {
    public TapeRepresenter(FileResolver fileResolver) {
        this.setPropertyUtils(new TapePropertyUtils());
        this.representers.put(URI.class, new RepresentURI());
        this.representers.put(File.class, new RepresentFile(fileResolver));
    }

    protected NodeTuple representJavaBeanProperty(Object bean, Property property, Object value, Tag customTag) {
        NodeTuple tuple = super.representJavaBeanProperty(bean, property, value, customTag);
        if (this.isNullValue(tuple) || this.isEmptySequence(tuple) || this.isEmptyMapping(tuple)) {
            return null;
        }
        if ("body".equals(property.getName())) {
            ScalarNode n = (ScalarNode)tuple.getValueNode();
            if (n.getStyle() == DumperOptions.ScalarStyle.PLAIN.getChar()) {
                return tuple;
            }
            return new NodeTuple(tuple.getKeyNode(), (Node)new ScalarNode(n.getTag(), n.getValue(), n.getStartMark(), n.getEndMark(), DumperOptions.ScalarStyle.LITERAL.getChar()));
        }
        return tuple;
    }

    protected Node representMapping(Tag tag, Map<?, ?> mapping, Boolean flowStyle) {
        return super.representMapping(tag, this.sort(mapping), flowStyle);
    }

    private <K, V> Map<K, V> sort(Map<K, V> self) {
        return new TreeMap<K, V>(self);
    }

    private boolean isNullValue(NodeTuple tuple) {
        return tuple.getValueNode().getTag().equals((Object)Tag.NULL);
    }

    private boolean isEmptySequence(NodeTuple tuple) {
        return tuple.getValueNode() instanceof SequenceNode && ((SequenceNode)tuple.getValueNode()).getValue().isEmpty();
    }

    private boolean isEmptyMapping(NodeTuple tuple) {
        return tuple.getValueNode() instanceof MappingNode && ((MappingNode)tuple.getValueNode()).getValue().isEmpty();
    }

    public static class OrderedPropertyComparator
    implements Comparator<Property> {
        private List<String> propertyNames;

        public static OrderedPropertyComparator forNames(String ... propertyNames) {
            return new OrderedPropertyComparator(propertyNames);
        }

        private OrderedPropertyComparator(String ... propertyNames) {
            this.propertyNames = Arrays.asList(propertyNames);
        }

        @Override
        public int compare(Property a, Property b) {
            return Ints.compare((int)this.propertyNames.indexOf(a.getName()), (int)this.propertyNames.indexOf(b.getName()));
        }
    }

    public class TapePropertyUtils
    extends PropertyUtils {
        protected Set<Property> createPropertySet(Class<?> type, BeanAccess bAccess) {
            try {
                Set properties = super.createPropertySet(type, bAccess);
                if (Tape.class.isAssignableFrom(type)) {
                    return this.sort(properties, "name", "interactions");
                }
                if (RecordedInteraction.class.isAssignableFrom(type)) {
                    return this.sort(properties, "recorded", "request", "response");
                }
                if (RecordedRequest.class.isAssignableFrom(type)) {
                    return this.sort(properties, "method", "uri", "headers", "body");
                }
                if (RecordedResponse.class.isAssignableFrom(type)) {
                    return this.sort(properties, "status", "headers", "body");
                }
                return properties;
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }

        private Set<Property> sort(Set<Property> properties, String ... names) {
            return Sets.newLinkedHashSet((Iterable)Ordering.from((Comparator)OrderedPropertyComparator.forNames(names)).sortedCopy(properties));
        }
    }

    private class RepresentFile
    implements Represent {
        private final FileResolver fileResolver;

        public RepresentFile(FileResolver fileResolver) {
            this.fileResolver = fileResolver;
        }

        public Node representData(Object data) {
            return TapeRepresenter.this.representScalar(YamlTape.FILE_TAG, this.fileResolver.toPath((File)data));
        }
    }

    private class RepresentURI
    implements Represent {
        private RepresentURI() {
        }

        public Node representData(Object data) {
            return TapeRepresenter.this.representScalar(Tag.STR, data.toString());
        }
    }
}

