/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.tape;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import software.betamax.Configuration;
import software.betamax.MatchRule;
import software.betamax.TapeMode;
import software.betamax.encoding.DeflateEncoder;
import software.betamax.encoding.GzipEncoder;
import software.betamax.handler.NonWritableTapeException;
import software.betamax.io.FileResolver;
import software.betamax.io.FileTypeMapper;
import software.betamax.io.FilenameNormalizer;
import software.betamax.message.Message;
import software.betamax.message.Request;
import software.betamax.message.Response;
import software.betamax.message.tape.RecordedMessage;
import software.betamax.message.tape.RecordedRequest;
import software.betamax.message.tape.RecordedResponse;
import software.betamax.tape.EntityStorage;
import software.betamax.tape.RecordedInteraction;
import software.betamax.tape.Tape;

public abstract class MemoryTape
implements Tape {
    private String name;
    private List<RecordedInteraction> interactions = Lists.newArrayList();
    private transient TapeMode mode = Configuration.DEFAULT_MODE;
    private transient MatchRule matchRule = Configuration.DEFAULT_MATCH_RULE;
    private transient EntityStorage responseBodyStorage = Configuration.DEFAULT_RESPONSE_BODY_STORAGE;
    private final transient FileResolver fileResolver;
    private transient AtomicInteger orderedIndex = new AtomicInteger();

    protected MemoryTape(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public TapeMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(TapeMode mode) {
        this.mode = mode;
    }

    @Override
    public MatchRule getMatchRule() {
        return this.matchRule;
    }

    @Override
    public void setMatchRule(MatchRule matchRule) {
        this.matchRule = matchRule;
    }

    @Override
    public void setResponseBodyStorage(EntityStorage responseBodyStorage) {
        this.responseBodyStorage = responseBodyStorage;
    }

    @Override
    public boolean isReadable() {
        return this.mode.isReadable();
    }

    @Override
    public boolean isWritable() {
        return this.mode.isWritable();
    }

    @Override
    public boolean isSequential() {
        return this.mode.isSequential();
    }

    @Override
    public int size() {
        return this.interactions.size();
    }

    public List<RecordedInteraction> getInteractions() {
        return Collections.unmodifiableList(this.interactions);
    }

    public void setInteractions(List<RecordedInteraction> interactions) {
        this.interactions = Lists.newArrayList(interactions);
    }

    @Override
    public boolean seek(Request request) {
        if (this.isSequential()) {
            try {
                Integer index = this.orderedIndex.get();
                RecordedInteraction interaction = this.interactions.get(index);
                RecordedRequest nextRequest = interaction == null ? null : interaction.getRequest();
                return nextRequest != null && this.matchRule.isMatch(request, nextRequest);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NonWritableTapeException();
            }
        }
        return this.findMatch(request) >= 0;
    }

    @Override
    public Response play(Request request) {
        if (!this.mode.isReadable()) {
            throw new IllegalStateException("the tape is not readable");
        }
        if (this.mode.isSequential()) {
            Integer nextIndex = this.orderedIndex.getAndIncrement();
            RecordedInteraction nextInteraction = this.interactions.get(nextIndex);
            if (nextInteraction == null) {
                throw new IllegalStateException(String.format("No recording found at position %s", nextIndex));
            }
            if (!this.matchRule.isMatch(request, nextInteraction.getRequest())) {
                throw new IllegalStateException(String.format("Request %s does not match recorded request %s", this.stringify(request), this.stringify(nextInteraction.getRequest())));
            }
            return nextInteraction.getResponse();
        }
        int position = this.findMatch(request);
        if (position < 0) {
            throw new IllegalStateException("no matching recording found");
        }
        return this.interactions.get(position).getResponse();
    }

    private String stringify(Request request) {
        return "method: " + request.getMethod() + ", " + "uri: " + request.getUri() + ", " + "headers: " + request.getHeaders() + ", " + "body: " + request.getBodyAsText();
    }

    @Override
    public synchronized void record(Request request, Response response) {
        if (!this.mode.isWritable()) {
            throw new IllegalStateException("the tape is not writable");
        }
        RecordedInteraction interaction = new RecordedInteraction();
        if (this.mode.isSequential()) {
            this.interactions.add(interaction);
        } else {
            int position = this.findMatch(request);
            if (position >= 0) {
                this.interactions.set(position, interaction);
            } else {
                this.interactions.add(interaction);
            }
        }
        interaction.setRequest(this.recordRequest(request));
        interaction.setResponse(this.recordResponse(response));
        interaction.setRecorded(new Date());
    }

    public String toString() {
        return String.format("Tape[%s]", this.name);
    }

    private synchronized int findMatch(final Request request) {
        return Iterables.indexOf(this.interactions, (Predicate)new Predicate<RecordedInteraction>(){

            public boolean apply(RecordedInteraction input) {
                return MemoryTape.this.matchRule.isMatch(request, input.getRequest());
            }
        });
    }

    private RecordedRequest recordRequest(Request request) {
        try {
            RecordedRequest recording = new RecordedRequest();
            recording.setMethod(request.getMethod());
            recording.setUri(request.getUri());
            for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
                if (header.getKey().equals("Via")) continue;
                ((HashMap)recording.getHeaders()).put(header.getKey(), header.getValue());
            }
            if (request.hasBody()) {
                this.recordBodyInline(request, recording);
            }
            return recording;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RecordedResponse recordResponse(Response response) {
        try {
            RecordedResponse recording = new RecordedResponse();
            recording.setStatus(response.getStatus());
            for (Map.Entry<String, String> header : response.getHeaders().entrySet()) {
                if (header.getKey().equals("Via") || header.getKey().equals("X-Betamax")) continue;
                ((HashMap)recording.getHeaders()).put(header.getKey(), header.getValue());
            }
            if (response.hasBody()) {
                this.recordResponseBody(response, recording);
            }
            return recording;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void recordResponseBody(Response response, RecordedResponse recording) throws IOException {
        switch (this.responseBodyStorage) {
            case external: {
                this.recordBodyToFile(response, recording);
                break;
            }
            default: {
                this.recordBodyInline(response, recording);
            }
        }
    }

    private void recordBodyInline(Message message, RecordedMessage recording) throws IOException {
        boolean representAsText = MemoryTape.isTextContentType(message.getContentType());
        if (representAsText) {
            if (message.getEncoding().equals("gzip")) {
                recording.setBody(new GzipEncoder().decode(new ByteArrayInputStream(message.getBodyAsBinary())));
            } else if (message.getEncoding().equals("deflate")) {
                recording.setBody(new DeflateEncoder().decode(new ByteArrayInputStream(message.getBodyAsBinary())));
            } else {
                recording.setBody(message.getBodyAsText());
            }
        } else {
            recording.setBody(message.getBodyAsBinary());
        }
    }

    private void recordBodyToFile(Message message, RecordedMessage recording) throws IOException {
        String filename = FileTypeMapper.filenameFor(String.format("response-%02d", this.size() + 1), message.getContentType());
        File body = this.fileResolver.toFile(FilenameNormalizer.toFilename(this.name), filename);
        Files.createParentDirs((File)body);
        ByteStreams.copy((InputStream)new ByteArrayInputStream(message.getBodyAsBinary()), (OutputStream)new FileOutputStream(body));
        recording.setBody(body);
    }

    private static boolean isTextContentType(String contentType) {
        return contentType != null && Pattern.compile("^text/|application/(json|javascript|(\\w+\\+)?xml|x-www-form-urlencoded)").matcher(contentType).find();
    }
}

