/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.proxy.netty;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import software.betamax.message.AbstractMessage;

public abstract class NettyMessageAdapter<T extends HttpMessage>
extends AbstractMessage {
    protected final T delegate;
    private final Multimap<String, String> headers = LinkedHashMultimap.create();
    private final CompositeByteBuf body = Unpooled.compositeBuffer();

    protected NettyMessageAdapter(T delegate) {
        this.delegate = delegate;
        this.copyHeaders((HttpMessage)delegate);
    }

    public void copyHeaders(HttpMessage httpMessage) {
        for (String name : httpMessage.headers().names()) {
            for (String value : httpMessage.headers().getAll(name)) {
                if (this.headers.containsEntry((Object)name, (Object)value)) continue;
                this.headers.put((Object)name, (Object)value);
            }
        }
    }

    public void append(HttpContent chunk) throws IOException {
        this.body.addComponent(Unpooled.copiedBuffer((ByteBuf)chunk.content()));
        this.body.writerIndex(this.body.writerIndex() + chunk.content().readableBytes());
    }

    @Override
    public Map<String, String> getHeaders() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.headers.keySet()) {
            builder.put((Object)name, (Object)this.getHeader(name));
        }
        return builder.build();
    }

    @Override
    public String getHeader(String name) {
        return Joiner.on((String)", ").join((Iterable)this.headers.get((Object)name));
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put((Object)name, (Object)value);
    }

    @Override
    public boolean hasBody() {
        return this.body.capacity() > 0;
    }

    @Override
    protected InputStream getBodyAsStream() throws IOException {
        return new ByteBufInputStream(Unpooled.copiedBuffer((ByteBuf)this.body));
    }
}

